/*
 * Decompiled with CFR 0.152.
 */
package de.ambertation.wunderlib.ui.layout.components;

import de.ambertation.wunderlib.ui.ColorHelper;
import de.ambertation.wunderlib.ui.layout.components.AbstractHorizontalStack;
import de.ambertation.wunderlib.ui.layout.components.ColorSwatch;
import de.ambertation.wunderlib.ui.layout.components.Input;
import de.ambertation.wunderlib.ui.layout.values.Value;
import net.minecraft.network.chat.Component;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ColorPicker
extends AbstractHorizontalStack<ColorPicker> {
    ColorSwatch swatch;
    Input input;

    public ColorPicker(Value width, Value height, Component title, int color) {
        super(width, height);
        this.swatch = this.addColorSwatch(Value.fixed(20), Value.fixed(20), color);
        this.input = this.addInput(Value.fill(), Value.fit(), title, ColorHelper.toRGBHex(color));
        this.input.setResponder(this::inputResponder);
    }

    private void inputResponder(String value) {
        if (ColorHelper.validHexColor(value)) {
            int color = ColorHelper.parseHex(value);
            this.swatch.setColor(color);
            this.swatch.setOffsetInner(false);
            this.swatch.setBorderColor(ColorHelper.BLACK);
        } else {
            this.swatch.setOffsetInner(true);
            this.swatch.setBorderColor(ColorHelper.RED);
        }
    }
}

