/*
 * Decompiled with CFR 0.152.
 */
package de.ambertation.wunderlib.ui.layout.components;

import de.ambertation.wunderlib.ui.ColorHelper;
import de.ambertation.wunderlib.ui.layout.components.LayoutComponent;
import de.ambertation.wunderlib.ui.layout.components.render.ComponentRenderer;
import de.ambertation.wunderlib.ui.layout.components.render.TextProvider;
import de.ambertation.wunderlib.ui.layout.values.Alignment;
import de.ambertation.wunderlib.ui.layout.values.Rectangle;
import de.ambertation.wunderlib.ui.layout.values.Value;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;

public class Text
extends LayoutComponent<TextRenderer, Text> {
    Component text;
    int color = ColorHelper.DEFAULT_TEXT;
    private boolean focused;

    public Text(Value width, Value height, Component text) {
        super(width, height, new TextRenderer());
        this.vAlign = Alignment.CENTER;
        ((TextRenderer)this.renderer).linkedComponent = this;
        this.text = text;
    }

    public Text setColor(int cl) {
        this.color = cl;
        return this;
    }

    public Text setText(Component text) {
        this.text = text;
        return this;
    }

    @Override
    public int getContentWidth() {
        return ((TextRenderer)this.renderer).getWidth(this.text);
    }

    @Override
    public int getContentHeight() {
        return ((TextRenderer)this.renderer).getHeight(this.text);
    }

    public boolean isFocused() {
        return this.focused;
    }

    public void setFocused(boolean bl) {
        this.focused = bl;
    }

    @Override
    public boolean isMouseOver(double d, double e) {
        return false;
    }

    public static class TextRenderer
    implements ComponentRenderer,
    TextProvider {
        Text linkedComponent;

        @Override
        public int getWidth(Component c) {
            return this.getFont().width(c.getVisualOrderText());
        }

        @Override
        public int getHeight(Component c) {
            return TextProvider.super.getLineHeight(c);
        }

        @Override
        public void renderInBounds(GuiGraphics guiGraphics, int mouseX, int mouseY, float deltaTicks, Rectangle bounds, Rectangle clipRect) {
            if (this.linkedComponent != null) {
                int left = bounds.width - this.getWidth(this.linkedComponent.text);
                if (this.linkedComponent.hAlign == Alignment.MIN) {
                    left = 0;
                }
                if (this.linkedComponent.hAlign == Alignment.CENTER) {
                    left /= 2;
                }
                int top = bounds.height - this.getLineHeight(this.linkedComponent.text);
                if (this.linkedComponent.vAlign == Alignment.MIN) {
                    top = 0;
                }
                if (this.linkedComponent.vAlign == Alignment.CENTER) {
                    top = top / 2 + 1;
                }
                guiGraphics.drawString(this.getFont(), this.linkedComponent.text, left, top, this.linkedComponent.color);
            }
        }
    }
}

