/*
 * Decompiled with CFR 0.152.
 */
package de.ambertation.wunderlib.ui.layout.values;

import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public interface SizeType {
    public static final FitContent FIT_CONTENT = new FitContent();
    public static final FitContentOrFill FIT_CONTENT_OR_FILL = new FitContentOrFill();
    public static final Fill FILL = new Fill();

    public static class FitContent
    implements SizeType {
        private final ContentSizeSupplier contentSize;

        public FitContent(ContentSizeSupplier contentSize) {
            this.contentSize = contentSize;
        }

        public FitContent() {
            this(null);
        }

        public FitContent copyForSupplier(ContentSizeSupplier component) {
            return new FitContent(component);
        }

        public ContentSizeSupplier contentSize() {
            return this.contentSize;
        }

        public String toString() {
            return this.getClass().getSimpleName();
        }

        @FunctionalInterface
        public static interface ContentSizeSupplier {
            public int get();
        }
    }

    public static class FitContentOrFill
    extends FitContent {
        public FitContentOrFill(FitContent.ContentSizeSupplier contentSize) {
            super(contentSize);
        }

        public FitContentOrFill() {
        }

        @Override
        public FitContentOrFill copyForSupplier(FitContent.ContentSizeSupplier component) {
            return new FitContentOrFill(component);
        }
    }

    public record Fill() implements SizeType
    {
    }

    public record Relative(double percentage) implements SizeType
    {
        @Override
        public String toString() {
            return this.getClass().getSimpleName() + "(" + this.percentage + ")";
        }
    }

    public record Fixed(int size) implements SizeType
    {
        @Override
        public String toString() {
            return this.getClass().getSimpleName() + "(" + this.size + ")";
        }
    }
}

