/*
 * Decompiled with CFR 0.152.
 */
package de.ambertation.wunderlib.ui.vanilla;

import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;

public class Slider<N extends Number>
extends AbstractSliderButton {
    protected final Component title;
    protected final N minValue;
    protected final N maxValue;
    protected final SliderValueChanged<N> onChange;

    public Slider(int x, int y, int width, int height, N minValue, N maxValue, N initialValue, SliderValueChanged<N> onChange) {
        this(x, y, width, height, null, minValue, maxValue, initialValue, onChange);
    }

    public Slider(int x, int y, int width, int height, Component title, N minValue, N maxValue, N initialValue, SliderValueChanged<N> onChange) {
        super(x, y, width, height, CommonComponents.EMPTY, (((Number)initialValue).doubleValue() - ((Number)minValue).doubleValue()) / (((Number)maxValue).doubleValue() - ((Number)minValue).doubleValue()));
        this.title = title;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.onChange = onChange;
        this.updateMessage();
    }

    public N currentValue() {
        Double res = this.value * (((Number)this.maxValue).doubleValue() - ((Number)this.minValue).doubleValue()) + ((Number)this.minValue).doubleValue();
        if (this.minValue instanceof Integer) {
            return (N)Integer.valueOf(res.intValue());
        }
        if (this.minValue instanceof Byte) {
            return (N)Byte.valueOf(res.byteValue());
        }
        if (this.minValue instanceof Short) {
            return (N)Short.valueOf(res.shortValue());
        }
        if (this.minValue instanceof Long) {
            return (N)Long.valueOf(res.longValue());
        }
        if (this.minValue instanceof Float) {
            return (N)Float.valueOf(res.floatValue());
        }
        if (this.minValue instanceof Double) {
            return (N)res;
        }
        throw new IllegalStateException("The Type " + this.minValue.getClass().getSimpleName() + " is not nativley supported. Please override currentValue with an implementation ofr that type");
    }

    protected String valueToString(N value) {
        if (this.minValue instanceof Float || this.minValue instanceof Double) {
            double v = ((Number)value).doubleValue();
            double m = ((Number)this.maxValue).doubleValue();
            if (m > 1000.0) {
                return "" + (int)v;
            }
            if (m > 100.0) {
                return String.format("%.1f", v);
            }
            if (m > 10.0) {
                return String.format("%.2f", v);
            }
            return String.format("%.4f", v);
        }
        return String.valueOf(value);
    }

    public Component getValueComponent(N value) {
        return Component.literal((String)this.valueToString(value));
    }

    protected void updateMessage() {
        Component valueComponent = this.getValueComponent(this.currentValue());
        this.setMessage((Component)(this.title == null ? valueComponent : this.title.copy().append(": ").append(valueComponent)));
    }

    protected void applyValue() {
        this.onChange.now(this, this.currentValue());
    }

    @FunctionalInterface
    public static interface SliderValueChanged<N extends Number> {
        public void now(Slider<N> var1, N var2);
    }
}

