/*
 * Decompiled with CFR 0.152.
 */
package de.ambertation.wunderlib.utils;

import de.ambertation.wunderlib.WunderLib;
import de.ambertation.wunderlib.utils.ColorUtilARGB32;
import java.util.Locale;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.resources.ResourceLocation;

public class Version {
    public static final Version ZERO = new Version(0, 0, 0);
    public final String version;

    public Version(String version) {
        if ("${version}".equals(version)) {
            version = "0.0.0";
        }
        this.version = version.trim();
    }

    public Version(int major, int minor, int patch) {
        this(String.format(Locale.ROOT, "%d.%d.%d", major, minor, patch));
    }

    private static int toInt(String version) {
        if (version == null || version.isEmpty()) {
            return 0;
        }
        try {
            String semanticVersionPattern = "(\\d+)\\.(\\d+)(\\.(\\d+))?\\D*";
            Matcher matcher = Pattern.compile("(\\d+)\\.(\\d+)(\\.(\\d+))?\\D*").matcher(version);
            int major = 0;
            int minor = 0;
            int patch = 0;
            if (matcher.find()) {
                if (matcher.groupCount() > 0) {
                    int n = major = matcher.group(1) == null ? 0 : Integer.parseInt(matcher.group(1));
                }
                if (matcher.groupCount() > 1) {
                    int n = minor = matcher.group(2) == null ? 0 : Integer.parseInt(matcher.group(2));
                }
                if (matcher.groupCount() > 3) {
                    patch = matcher.group(4) == null ? 0 : Integer.parseInt(matcher.group(4));
                }
            }
            return ColorUtilARGB32.color(0, major, minor, patch);
        }
        catch (Exception e) {
            WunderLib.LOGGER.error("Failed to parse Version '" + version + "'.");
            return 0;
        }
    }

    public static int major(int version) {
        return ColorUtilARGB32.red(version);
    }

    public static int minor(int version) {
        return ColorUtilARGB32.green(version);
    }

    public static int patch(int version) {
        return ColorUtilARGB32.blue(version);
    }

    public static Version fromInt(int version) {
        return new Version(Version.major(version), Version.minor(version), Version.patch(version));
    }

    public int toInt() {
        return Version.toInt(this.version);
    }

    public boolean isLargerThan(Version v2) {
        return this.toInt() > v2.toInt();
    }

    public boolean isLargerOrEqualVersion(Version v2) {
        return this.toInt() >= v2.toInt();
    }

    public boolean isLargerThan(String v2) {
        return this.toInt() > Version.toInt(v2);
    }

    public boolean isLargerOrEqualVersion(String v2) {
        return this.toInt() >= Version.toInt(v2);
    }

    public boolean isLessThan(Version v2) {
        return this.toInt() < v2.toInt();
    }

    public boolean isLessOrEqualVersion(Version v2) {
        return this.toInt() <= v2.toInt();
    }

    public boolean isLessThan(String v2) {
        return this.toInt() < Version.toInt(v2);
    }

    public boolean isLessOrEqualVersion(String v2) {
        return this.toInt() <= Version.toInt(v2);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof String) {
            String s = (String)o;
            return this.version.equals(s.trim());
        }
        if (!(o instanceof Version)) {
            return false;
        }
        Version version1 = (Version)o;
        return Objects.equals(this.version, version1.version);
    }

    public int hashCode() {
        return Objects.hashCode(this.version);
    }

    public String toString() {
        return this.version;
    }

    public static interface ModVersionProvider {
        public Version getModVersion();

        public String getModID();

        default public String getNamespace() {
            return this.getModID();
        }

        default public ResourceLocation mk(String key) {
            return ResourceLocation.fromNamespaceAndPath((String)this.getModID(), (String)key);
        }
    }
}

