/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.complex.api.equipment;

import java.util.function.Supplier;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.betterx.wover.complex.api.equipment.ArmorSlot;
import org.betterx.wover.complex.api.equipment.ArmorTier;
import org.betterx.wover.complex.api.equipment.EquipmentSet;
import org.betterx.wover.complex.api.equipment.ItemDescription;
import org.betterx.wover.core.api.ModCore;
import org.betterx.wover.recipe.api.CraftingRecipeBuilder;
import org.betterx.wover.recipe.api.RecipeBuilder;
import org.betterx.wover.recipe.api.SmithingRecipeBuilder;
import org.jetbrains.annotations.Nullable;

public class ArmorDescription<I extends Item>
extends ItemDescription<I> {
    private final ArmorSlot slot;

    private static TagKey<Item>[] getTagKey(ArmorSlot slot) {
        TagKey[] tagKeyArray;
        switch (slot) {
            case HELMET_SLOT: {
                TagKey[] tagKeyArray2 = new TagKey[1];
                tagKeyArray = tagKeyArray2;
                tagKeyArray2[0] = ItemTags.HEAD_ARMOR;
                break;
            }
            case CHESTPLATE_SLOT: {
                TagKey[] tagKeyArray3 = new TagKey[1];
                tagKeyArray = tagKeyArray3;
                tagKeyArray3[0] = ItemTags.CHEST_ARMOR;
                break;
            }
            case LEGGINGS_SLOT: {
                TagKey[] tagKeyArray4 = new TagKey[1];
                tagKeyArray = tagKeyArray4;
                tagKeyArray4[0] = ItemTags.LEG_ARMOR;
                break;
            }
            case BOOTS_SLOT: {
                TagKey[] tagKeyArray5 = new TagKey[1];
                tagKeyArray = tagKeyArray5;
                tagKeyArray5[0] = ItemTags.FOOT_ARMOR;
                break;
            }
            default: {
                tagKeyArray = new TagKey[]{};
            }
        }
        return tagKeyArray;
    }

    public ArmorDescription(ModCore modCore, ArmorSlot slot, String path, Supplier<I> creator) {
        super(modCore, path, creator, ArmorDescription.getTagKey(slot));
        this.slot = slot;
    }

    public void addRecipe(RecipeOutput ctx, ArmorTier tier, ItemLike stick, @Nullable EquipmentSet sourceSet) {
        if (this.item == null) {
            return;
        }
        if (tier == null) {
            return;
        }
        Supplier repair = ((ArmorMaterial)tier.armorMaterial.value()).repairIngredient();
        Ingredient ingot = (Ingredient)repair.get();
        if (ingot.isEmpty()) {
            return;
        }
        ArmorTier.ArmorValues values = tier.getValues(this.slot);
        if (values != null && values.smithingTemplate() != null && sourceSet != null) {
            ((SmithingRecipeBuilder)RecipeBuilder.smithing(this.location, (ItemLike)this.item).template(values.smithingTemplate()).base((ItemLike)sourceSet.get(this.slot)).addon(ingot).category(this.slot.category)).build(ctx);
        } else {
            CraftingRecipeBuilder builder = (CraftingRecipeBuilder)RecipeBuilder.crafting(this.location, (ItemLike)this.item).addMaterial('#', ingot).category(RecipeCategory.TOOLS);
            if (ArmorDescription.buildRecipe(this.item, stick, builder)) {
                return;
            }
            ((CraftingRecipeBuilder)builder.category(this.slot.category)).group(this.location.getPath()).build(ctx);
        }
    }
}

