/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.complex.api.equipment;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.ItemLike;
import org.betterx.wover.complex.api.equipment.ArmorDescription;
import org.betterx.wover.complex.api.equipment.ArmorSlot;
import org.betterx.wover.complex.api.equipment.ArmorTier;
import org.betterx.wover.complex.api.equipment.ItemDescription;
import org.betterx.wover.complex.api.equipment.ToolDescription;
import org.betterx.wover.complex.api.equipment.ToolSlot;
import org.betterx.wover.complex.api.equipment.ToolTier;
import org.betterx.wover.core.api.ModCore;
import org.jetbrains.annotations.NotNull;

public abstract class EquipmentSet {
    private static final List<EquipmentSet> SETS = new LinkedList<EquipmentSet>();
    public final ToolTier toolTier;
    public final ArmorTier armorTier;
    public final String baseName;
    public final ModCore C;
    public final ItemLike handleItem;
    private final Map<ToolSlot, ToolDescription<?>> tools = new HashMap();
    private final Map<ArmorSlot, ArmorDescription<?>> armors = new HashMap();
    protected final EquipmentSet templateBaseSet;

    public EquipmentSet(ModCore C, String baseName, ToolTier toolTier, ArmorTier armorTier, ItemLike handleItem) {
        this(C, baseName, toolTier, armorTier, handleItem, null);
    }

    public EquipmentSet(ModCore C, String baseName, ToolTier toolTier, ArmorTier armorTier, ItemLike handleItem, EquipmentSet templateBaseSet) {
        this.C = C;
        this.baseName = baseName;
        this.toolTier = toolTier;
        this.armorTier = armorTier;
        this.handleItem = handleItem;
        this.templateBaseSet = templateBaseSet;
        SETS.add(this);
    }

    public <I extends Item> void add(ToolSlot slot, ToolFactory<I> toolFactory) {
        this.add(slot, toolFactory, ToolSlot::buildProperties);
    }

    public <I extends Item> void add(ToolSlot slot, ToolFactory<I> toolFactory, ToolSlot.PropertiesBuilder propertiesBuilder) {
        this.tools.put(slot, new ToolDescription<Item>(this.C, slot, this.nameForSlot(slot), () -> toolFactory.create(this.toolTier.toolTier, propertiesBuilder.build(slot, this.toolTier))));
    }

    public <I extends Item> void add(ArmorSlot slot, ArmorFactory<I> armorFactory) {
        this.add(slot, armorFactory, ArmorSlot::buildProperties);
    }

    public <I extends Item> void add(ArmorSlot slot, ArmorFactory<I> armorFactory, ArmorSlot.PropertiesBuilder propertiesBuilder) {
        this.armors.put(slot, new ArmorDescription<Item>(this.C, slot, this.nameForSlot(slot), () -> armorFactory.create(this.armorTier.armorMaterial, slot.armorType, propertiesBuilder.build(slot, this.armorTier))));
    }

    public void buildRecipes(RecipeOutput ctx) {
        for (Map.Entry<ToolSlot, ToolDescription<?>> entry : this.tools.entrySet()) {
            entry.getValue().addRecipe(ctx, this.toolTier, this.handleItem, this.templateBaseSet);
        }
        for (Map.Entry<Enum, ItemDescription> entry : this.armors.entrySet()) {
            ((ArmorDescription)entry.getValue()).addRecipe(ctx, this.armorTier, this.handleItem, this.templateBaseSet);
        }
    }

    public static void buildAllRecipes(ModCore modCore, RecipeOutput ctx) {
        SETS.stream().filter(set -> set.C == modCore).forEach(set -> set.buildRecipes(ctx));
    }

    @NotNull
    private String nameForSlot(ToolSlot slot) {
        return this.nameForSlot(slot.name);
    }

    @NotNull
    private String nameForSlot(ArmorSlot slot) {
        return this.nameForSlot(slot.name);
    }

    @NotNull
    protected String nameForSlot(String slotName) {
        return this.baseName + "_" + slotName;
    }

    public <I extends Item> I get(ToolSlot slot) {
        return this.tools.get((Object)slot).getItem();
    }

    public <I extends Item> I get(ArmorSlot slot) {
        return (I)this.armors.get((Object)slot).getItem();
    }

    public Item[] getTools() {
        Item[] items = new Item[this.tools.size()];
        int i = 0;
        for (ToolDescription<?> desc : this.tools.values()) {
            items[i++] = desc.getItem();
        }
        return items;
    }

    public Item[] getArmorPieces() {
        Item[] items = new Item[this.armors.size()];
        int i = 0;
        for (ArmorDescription<?> desc : this.armors.values()) {
            items[i++] = desc.getItem();
        }
        return items;
    }

    public Item[] getAll() {
        Item[] items = new Item[this.tools.size() + this.armors.size()];
        int i = 0;
        for (ToolDescription<?> toolDescription : this.tools.values()) {
            items[i++] = toolDescription.getItem();
        }
        for (ArmorDescription armorDescription : this.armors.values()) {
            items[i++] = armorDescription.getItem();
        }
        return items;
    }

    public static interface ToolFactory<I extends Item> {
        public I create(Tier var1, Item.Properties var2);
    }

    public static interface ArmorFactory<I extends Item> {
        public I create(Holder<ArmorMaterial> var1, ArmorItem.Type var2, Item.Properties var3);
    }
}

