/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.complex.api.equipment;

import java.util.function.Supplier;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.betterx.wover.complex.api.equipment.EquipmentSet;
import org.betterx.wover.complex.api.equipment.ItemDescription;
import org.betterx.wover.complex.api.equipment.ToolSlot;
import org.betterx.wover.complex.api.equipment.ToolTier;
import org.betterx.wover.core.api.ModCore;
import org.betterx.wover.recipe.api.CraftingRecipeBuilder;
import org.betterx.wover.recipe.api.RecipeBuilder;
import org.betterx.wover.recipe.api.SmithingRecipeBuilder;
import org.betterx.wover.tag.api.predefined.CommonItemTags;
import org.jetbrains.annotations.Nullable;

class ToolDescription<I extends Item>
extends ItemDescription<I> {
    public final ToolSlot slot;

    private static TagKey<Item>[] getTagKey(ToolSlot slot) {
        TagKey[] tagKeyArray;
        switch (slot) {
            case PICKAXE_SLOT: {
                TagKey[] tagKeyArray2 = new TagKey[1];
                tagKeyArray = tagKeyArray2;
                tagKeyArray2[0] = ItemTags.PICKAXES;
                break;
            }
            case AXE_SLOT: {
                TagKey[] tagKeyArray3 = new TagKey[1];
                tagKeyArray = tagKeyArray3;
                tagKeyArray3[0] = ItemTags.AXES;
                break;
            }
            case SHOVEL_SLOT: {
                TagKey[] tagKeyArray4 = new TagKey[1];
                tagKeyArray = tagKeyArray4;
                tagKeyArray4[0] = ItemTags.SHOVELS;
                break;
            }
            case HOE_SLOT: {
                TagKey[] tagKeyArray5 = new TagKey[1];
                tagKeyArray = tagKeyArray5;
                tagKeyArray5[0] = ItemTags.HOES;
                break;
            }
            case SWORD_SLOT: {
                TagKey[] tagKeyArray6 = new TagKey[1];
                tagKeyArray = tagKeyArray6;
                tagKeyArray6[0] = ItemTags.SWORDS;
                break;
            }
            case SHEARS_SLOT: {
                TagKey[] tagKeyArray7 = new TagKey[1];
                tagKeyArray = tagKeyArray7;
                tagKeyArray7[0] = CommonItemTags.SHEARS;
                break;
            }
            case HAMMER_SLOT: {
                TagKey[] tagKeyArray8 = new TagKey[1];
                tagKeyArray = tagKeyArray8;
                tagKeyArray8[0] = CommonItemTags.HAMMERS;
                break;
            }
            default: {
                tagKeyArray = new TagKey[]{};
            }
        }
        return tagKeyArray;
    }

    public ToolDescription(ModCore modCore, ToolSlot slot, String path, Supplier<I> creator) {
        super(modCore, path, creator, ToolDescription.getTagKey(slot));
        this.slot = slot;
    }

    public void addRecipe(RecipeOutput ctx, ToolTier tier, ItemLike stick, @Nullable EquipmentSet sourceSet) {
        if (this.item == null) {
            return;
        }
        if (tier == null) {
            return;
        }
        Ingredient repair = tier.toolTier.getRepairIngredient();
        ItemStack[] repairItems = repair.getItems();
        if (repairItems.length == 0) {
            return;
        }
        Item ingot = repairItems[0].getItem();
        ToolTier.ToolValues values = tier.getValues(this.slot);
        if (values != null && values.smithingTemplate() != null && sourceSet != null) {
            ((SmithingRecipeBuilder)RecipeBuilder.smithing(this.location, (ItemLike)this.item).template(values.smithingTemplate()).base((ItemLike)sourceSet.get(this.slot)).addon((ItemLike)ingot).category(this.slot.category)).build(ctx);
        } else {
            CraftingRecipeBuilder builder = (CraftingRecipeBuilder)RecipeBuilder.crafting(this.location, (ItemLike)this.item).addMaterial('#', new ItemLike[]{ingot}).category(RecipeCategory.TOOLS);
            if (ToolDescription.buildRecipe(this.item, stick, builder)) {
                return;
            }
            ((CraftingRecipeBuilder)builder.category(this.slot.category)).group(this.location.getPath()).build(ctx);
        }
    }
}

