/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.config.api;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import org.betterx.wover.entrypoint.LibWoverCore;
import org.jetbrains.annotations.Nullable;

public class DatapackConfigs {
    private static DatapackConfigs INSTANCE = new DatapackConfigs();

    public static DatapackConfigs instance() {
        return INSTANCE;
    }

    public void runForResource(ResourceManager manager, ResourceLocation fileLocation, DatapackConfigReloadHandler handler) {
        Map aSet = manager.listResourceStacks("config", id -> {
            LibWoverCore.C.log.debug("Checking Resource from Datapack: '{}'", id);
            return fileLocation.getNamespace().equals(id.getNamespace()) && id.getPath().equals("config/" + fileLocation.getPath());
        });
        DatapackConfigs.runForSet(handler, null, aSet);
    }

    public void runForConfigPaths(ResourceManager manager, List<String> paths, @Nullable DatapackConfigReloadHandler handler, @Nullable DatapackConfigFinished finished) {
        Map aSet = manager.listResourceStacks("config", id -> {
            LibWoverCore.C.log.debug("Checking Resource from Datapack: '{}'", id);
            return paths.contains(id.getPath());
        });
        DatapackConfigs.runForSet(handler, finished, aSet);
    }

    private static void runForSet(@Nullable DatapackConfigReloadHandler handler, @Nullable DatapackConfigFinished finished, Map<ResourceLocation, List<Resource>> resources) {
        if (handler != null) {
            for (Map.Entry<ResourceLocation, List<Resource>> entry : resources.entrySet()) {
                for (Resource item : entry.getValue()) {
                    try {
                        BufferedReader reader = item.openAsReader();
                        try {
                            JsonObject obj = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                            if (obj == null) continue;
                            handler.onLoad(entry.getKey(), obj);
                        }
                        finally {
                            if (reader == null) continue;
                            ((Reader)reader).close();
                        }
                    }
                    catch (Exception e) {
                        LibWoverCore.C.log.error("Error occurred while loading resource json " + String.valueOf(entry.getKey()), e);
                    }
                }
            }
        }
        if (finished != null) {
            finished.whenFinished();
        }
    }

    @FunctionalInterface
    public static interface DatapackConfigReloadHandler {
        public void onLoad(ResourceLocation var1, JsonObject var2);
    }

    @FunctionalInterface
    public static interface DatapackConfigFinished {
        public void whenFinished();
    }
}

