/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.core.api;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.betterx.wover.config.api.Configs;
import org.betterx.wover.core.api.ModCore;

public final class Logger
extends de.ambertation.wunderlib.general.Logger {
    private static final Map<String, Logger> cache = new ConcurrentHashMap<String, Logger>();

    private Logger(String modID) {
        super(modID);
    }

    static Logger create(String modID) {
        return cache.computeIfAbsent(modID, id -> new Logger((String)id));
    }

    public static Logger create(ModCore mod) {
        return cache.computeIfAbsent(mod.modId, id -> new Logger((String)id));
    }

    public void debug(String message) {
        if (ModCore.isDevEnvironment()) {
            this.info("(DEBUG) " + message);
        } else {
            super.debug(message);
        }
    }

    public void debug(String message, Object ... params) {
        if (ModCore.isDevEnvironment()) {
            this.info("(DEBUG) " + message, params);
        } else {
            super.debug(message, params);
        }
    }

    public void verbose(String message) {
        if (((Boolean)Configs.MAIN.verboseLogging.get()).booleanValue()) {
            this.info(message);
        }
    }

    public void verbose(String message, Object ... params) {
        if (((Boolean)Configs.MAIN.verboseLogging.get()).booleanValue()) {
            this.info(message, params);
        }
    }

    public void verboseWarning(String message) {
        if (((Boolean)Configs.MAIN.verboseLogging.get()).booleanValue()) {
            this.warn(message);
        }
    }

    public void verboseWarning(String message, Object ... params) {
        if (((Boolean)Configs.MAIN.verboseLogging.get()).booleanValue()) {
            this.warn(message, params);
        }
    }

    public void verboseError(String message) {
        if (((Boolean)Configs.MAIN.verboseLogging.get()).booleanValue()) {
            this.error(message);
        }
    }

    public void verboseError(String message, Exception e) {
        if (((Boolean)Configs.MAIN.verboseLogging.get()).booleanValue()) {
            this.error(message, e);
        }
    }
}

