/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.core.api;

import de.ambertation.wunderlib.utils.Version;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackSelectionConfig;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.PathPackResources;
import net.minecraft.server.packs.repository.KnownPack;
import net.minecraft.server.packs.repository.Pack;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.neoforge.data.loading.DatagenModLoader;
import net.neoforged.neoforge.event.AddPackFindersEvent;
import net.neoforged.neoforgespi.language.IModInfo;
import net.neoforged.neoforgespi.locating.IModFile;
import org.betterx.wover.core.api.DatapackActivationType;
import org.betterx.wover.core.api.Logger;

public final class ModCore
implements Version.ModVersionProvider {
    private static final Map<String, ModCore> cache = new ConcurrentHashMap<String, ModCore>();
    private final List<DatapackInfo> providedDatapacks = new LinkedList<DatapackInfo>();
    public final Logger LOG;
    public final Logger log;
    public final String modId;
    public final String namespace;
    private final Version modVersion;
    public final ModContainer modContainer;

    private ModCore(String modID, String namespace) {
        this.log = this.LOG = Logger.create(modID);
        this.modId = modID;
        this.namespace = namespace;
        ModList modList = ModList.get();
        Optional optional = Optional.empty();
        if (modList != null && (optional = modList.getModContainerById(this.modId)).isEmpty() && "wover".equals(namespace) && !"wover".equals(this.modId)) {
            optional = modList.getModContainerById("wover");
        }
        if (optional.isPresent()) {
            this.modContainer = (ModContainer)optional.get();
            this.modVersion = new Version(this.modContainer.getModInfo().getVersion().toString());
        } else {
            this.modContainer = null;
            this.modVersion = new Version(0, 0, 0);
        }
    }

    public Version getModVersion() {
        return this.modVersion;
    }

    public String getModID() {
        return this.modId;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public ResourceLocation id(String name) {
        return ResourceLocation.fromNamespaceAndPath((String)this.namespace, (String)name);
    }

    public ResourceLocation convertNamespace(ResourceLocation location) {
        return this.id(location.getPath());
    }

    public <T> ResourceLocation convertNamespace(ResourceKey<T> key) {
        return this.convertNamespace(key.location());
    }

    public ResourceLocation mk(String key) {
        return ResourceLocation.fromNamespaceAndPath((String)this.namespace, (String)key);
    }

    public boolean isLoaded() {
        return this.modContainer != null;
    }

    public Stream<ResourceLocation> providedDatapacks() {
        return this.providedDatapacks.stream().map(DatapackInfo::id);
    }

    public ResourceLocation addDatapack(String name, DatapackActivationType activationType) {
        ResourceLocation id = this.id(name);
        this.providedDatapacks.add(new DatapackInfo(id, activationType));
        return id;
    }

    public void registerDatapackListener(IEventBus modEventBus) {
        modEventBus.addListener(this::onAddPackFinders);
    }

    private void onAddPackFinders(AddPackFindersEvent event) {
        if (event.getPackType() != PackType.SERVER_DATA || this.modContainer == null) {
            return;
        }
        IModInfo modInfo = this.modContainer.getModInfo();
        IModFile modFile = modInfo.getOwningFile().getFile();
        String modVersion = modInfo.getVersion().toString();
        for (DatapackInfo info : this.providedDatapacks) {
            PackSelectionConfig selectionConfig;
            Pack.ResourcesSupplier resources;
            MutableComponent title;
            final Path packRoot = ModCore.resolvePackRoot(modFile, info.id.getPath());
            if (packRoot == null) {
                this.LOG.warn("Skipping built-in datapack {}: pack.mcmeta not found.", new Object[]{info.id});
                continue;
            }
            String packId = "mod/" + String.valueOf(info.id);
            PackLocationInfo locationInfo = new PackLocationInfo(packId, (Component)(title = Component.translatable((String)("pack." + info.id.getNamespace() + "." + info.id.getPath() + ".description"))), info.activationType.packSource(), Optional.of(new KnownPack("neoforge", packId, modVersion)));
            Pack pack = Pack.readMetaAndCreate((PackLocationInfo)locationInfo, (Pack.ResourcesSupplier)(resources = new Pack.ResourcesSupplier(){

                public PackResources openPrimary(PackLocationInfo location) {
                    return new PathPackResources(location, packRoot);
                }

                public PackResources openFull(PackLocationInfo location, Pack.Metadata metadata) {
                    return new PathPackResources(location, packRoot);
                }
            }), (PackType)PackType.SERVER_DATA, (PackSelectionConfig)(selectionConfig = new PackSelectionConfig(info.activationType.alwaysActive(), Pack.Position.TOP, false)));
            if (pack == null) {
                this.LOG.warn("Skipping built-in datapack {}: invalid pack metadata.", new Object[]{info.id});
                continue;
            }
            event.addRepositorySource(consumer -> consumer.accept(pack));
        }
    }

    private static Path resolvePackRoot(IModFile modFile, String packId) {
        Path root = modFile.findResource(new String[]{packId});
        if (root != null && Files.exists(root.resolve("pack.mcmeta"), new LinkOption[0])) {
            return root;
        }
        Path resourcepacks = modFile.findResource(new String[]{"resourcepacks", packId});
        if (resourcepacks != null && Files.exists(resourcepacks.resolve("pack.mcmeta"), new LinkOption[0])) {
            return resourcepacks;
        }
        return null;
    }

    public ResourceLocation addDatapack(ModCore dependency) {
        return this.addDatapack(dependency.namespace + "_extensions", dependency.isLoaded() ? DatapackActivationType.DEFAULT_ENABLED : DatapackActivationType.NORMAL);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ModCore)) {
            return false;
        }
        ModCore modCore = (ModCore)o;
        return Objects.equals(this.modId, modCore.modId) && Objects.equals(this.namespace, modCore.namespace);
    }

    public int hashCode() {
        return Objects.hash(this.modId, this.namespace);
    }

    public String toString() {
        return "ModCore: " + this.modId + " (" + this.namespace + ")";
    }

    public static ModCore create(String modID) {
        return cache.computeIfAbsent(modID, id -> new ModCore((String)id, (String)id));
    }

    public static ModCore create(String modID, String namespace) {
        return cache.computeIfAbsent(modID, id -> new ModCore((String)id, namespace));
    }

    public static boolean isDatagen() {
        return DatagenModLoader.isRunningDataGen();
    }

    public static boolean isDevEnvironment() {
        return !FMLLoader.isProduction();
    }

    public static boolean isClient() {
        return FMLEnvironment.dist.isClient();
    }

    public static boolean isServer() {
        return FMLEnvironment.dist.isDedicatedServer();
    }

    private record DatapackInfo(ResourceLocation id, DatapackActivationType activationType) {
    }
}

