/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.core.impl.registry;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.Registry;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import org.betterx.wover.core.api.registry.CustomBootstrapContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CustomBootstrapContextImpl<T> {
    private static final Map<ResourceKey<Registry<?>>, ContextData<?, ?>> CONTEXT_OBJECTS = new HashMap();

    @NotNull
    private static <T, C extends CustomBootstrapContext<T, C>> ContextData<T, C> getContextObject(ResourceKey<Registry<T>> registryKey) {
        return CONTEXT_OBJECTS.computeIfAbsent(registryKey, key -> new ContextData());
    }

    @Nullable
    public static <B, T, C extends CustomBootstrapContext<T, C>> C initContext(@Nullable BootstrapContext<B> lookupContext, @NotNull ResourceKey<Registry<T>> registryKey, @NotNull Supplier<C> contextSupplier) {
        ContextData<T, C> contextObject = CustomBootstrapContextImpl.getContextObject(registryKey);
        if (lookupContext == null) {
            return contextObject.bootstrapContext;
        }
        HolderGetter biomeGetter = lookupContext.lookup(registryKey);
        if (biomeGetter != contextObject.lastGetter) {
            contextObject.lastGetter = biomeGetter;
            contextObject.bootstrapContext = (CustomBootstrapContext)contextSupplier.get();
            ((CustomBootstrapContext)contextObject.bootstrapContext).setLookupContext(lookupContext);
            ((CustomBootstrapContext)contextObject.bootstrapContext).onBootstrapContextChange(contextObject.bootstrapContext);
        } else {
            ((CustomBootstrapContext)contextObject.bootstrapContext).setLookupContext(lookupContext);
        }
        return contextObject.bootstrapContext;
    }

    public static <T> void finalize(@NotNull ResourceKey<Registry<T>> registryKey) {
        CustomBootstrapContextImpl.getContextObject(registryKey).bootstrapContext = null;
    }

    private static class ContextData<T, C extends CustomBootstrapContext<T, C>> {
        private HolderGetter<T> lastGetter = null;
        private C bootstrapContext = null;

        private ContextData() {
        }
    }
}

