/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.datagen.api.provider;

import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.models.ItemModelGenerators;
import net.minecraft.data.models.blockstates.BlockStateGenerator;
import net.minecraft.data.models.model.DelegatedModel;
import net.minecraft.data.models.model.ModelLocationUtils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import org.betterx.wover.block.api.BlockRegistry;
import org.betterx.wover.block.api.model.BlockModelProvider;
import org.betterx.wover.block.api.model.WoverBlockModelGenerators;
import org.betterx.wover.block.api.model.WoverBlockModelGeneratorsAccess;
import org.betterx.wover.block.impl.ModelProviderExclusions;
import org.betterx.wover.core.api.ModCore;
import org.betterx.wover.datagen.api.WoverDataProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class WoverModelProvider
implements WoverDataProvider<DataProvider> {
    public final String title;
    protected final ModCore modCore;

    public WoverModelProvider(ModCore modCore) {
        this(modCore, modCore.namespace);
    }

    public WoverModelProvider(ModCore modCore, String title) {
        this.modCore = modCore;
        this.title = title;
    }

    protected void addFromRegistry(WoverBlockModelGenerators generator, BlockRegistry registry, boolean validate) {
        this.addFromRegistry(generator, registry, validate, ModelOverides.create());
    }

    protected void addFromRegistry(WoverBlockModelGenerators generator, BlockRegistry registry, boolean validateMissing, ModelOverides overrides) {
        registry.allBlocks().forEach(block -> {
            if (!overrides.provideBlockModel((Block)block) && block instanceof BlockModelProvider) {
                BlockModelProvider bmp = (BlockModelProvider)block;
                bmp.provideBlockModels(generator);
            } else if (validateMissing) {
                ModelProviderExclusions.excludeFromBlockModelValidation(block);
            }
            if (!validateMissing) {
                ModelProviderExclusions.excludeFromBlockModelValidation(block);
            }
        });
    }

    protected abstract void bootstrapBlockStateModels(WoverBlockModelGenerators var1);

    protected abstract void bootstrapItemModels(ItemModelGenerators var1);

    @Override
    public DataProvider getProvider(final PackOutput output, CompletableFuture<HolderLookup.Provider> registriesFuture, final ExistingFileHelper existingFileHelper) {
        return new DataProvider(){
            private final PackOutput.PathProvider blockStatePathProvider;
            private final PackOutput.PathProvider modelPathProvider;
            {
                this.blockStatePathProvider = output.createPathProvider(PackOutput.Target.RESOURCE_PACK, "blockstates");
                this.modelPathProvider = output.createPathProvider(PackOutput.Target.RESOURCE_PACK, "models");
            }

            public CompletableFuture<?> run(CachedOutput cache) {
                HashMap blockStates = Maps.newHashMap();
                Consumer<BlockStateGenerator> blockStateConsumer = generator -> {
                    Block block = generator.getBlock();
                    if (blockStates.put(block, generator) != null) {
                        throw new IllegalStateException("Duplicate blockstate definition for " + String.valueOf(block));
                    }
                };
                HashMap<ResourceLocation, Supplier<JsonElement>> models = new HashMap<ResourceLocation, Supplier<JsonElement>>();
                BiConsumer<ResourceLocation, Supplier<JsonElement>> modelOutput = (id, supplier) -> {
                    if (models.put((ResourceLocation)id, (Supplier<JsonElement>)supplier) != null) {
                        throw new IllegalStateException("Duplicate model definition for " + String.valueOf(id));
                    }
                };
                HashSet<Item> skippedItems = new HashSet<Item>();
                Consumer<Item> itemConsumer = skippedItems::add;
                WoverBlockModelGeneratorsAccess blockModelGenerators = new WoverBlockModelGeneratorsAccess(blockStateConsumer, modelOutput, itemConsumer);
                WoverModelProvider.this.bootstrapBlockStateModels(new WoverBlockModelGenerators(blockModelGenerators));
                ItemModelGenerators itemModelGenerators = new ItemModelGenerators(modelOutput);
                WoverModelProvider.this.bootstrapItemModels(itemModelGenerators);
                this.validateBlockStates(blockStates);
                this.addItemModelDelegates(models, skippedItems, existingFileHelper);
                CompletableFuture[] completableFutureArray = new CompletableFuture[2];
                completableFutureArray[0] = this.saveCollection(cache, blockStates, b -> this.blockStatePathProvider.json(b.builtInRegistryHolder().key().location()));
                completableFutureArray[1] = this.saveCollection(cache, models, arg_0 -> ((PackOutput.PathProvider)this.modelPathProvider).json(arg_0));
                return CompletableFuture.allOf(completableFutureArray);
            }

            private void validateBlockStates(Map<Block, BlockStateGenerator> blockStates) {
                for (Block block : BuiltInRegistries.BLOCK) {
                    ResourceLocation id;
                    if (ModelProviderExclusions.isExcluded(block) || (id = BuiltInRegistries.BLOCK.getKey((Object)block)) == null || !id.getNamespace().equals(WoverModelProvider.this.modCore.namespace) || blockStates.containsKey(block)) continue;
                    throw new IllegalStateException("Missing blockstate definition for " + String.valueOf(block));
                }
            }

            private void addItemModelDelegates(Map<ResourceLocation, Supplier<JsonElement>> models, Set<Item> skippedItems, ExistingFileHelper existingFileHelper2) {
                BuiltInRegistries.BLOCK.forEach(block -> {
                    ResourceLocation blockId = BuiltInRegistries.BLOCK.getKey(block);
                    if (blockId == null || !blockId.getNamespace().equals(WoverModelProvider.this.modCore.namespace)) {
                        return;
                    }
                    Item item = (Item)Item.BY_BLOCK.get(block);
                    if (item == null || skippedItems.contains(item)) {
                        return;
                    }
                    ResourceLocation modelId = ModelLocationUtils.getModelLocation((Item)item);
                    if (this.hasModel(modelId, models, existingFileHelper2)) {
                        return;
                    }
                    ResourceLocation blockModelId = ModelLocationUtils.getModelLocation((Block)block);
                    if (!this.hasModel(blockModelId, models, existingFileHelper2)) {
                        return;
                    }
                    models.put(modelId, (Supplier<JsonElement>)new DelegatedModel(blockModelId));
                });
            }

            private boolean hasModel(ResourceLocation modelId, Map<ResourceLocation, Supplier<JsonElement>> models, ExistingFileHelper existingFileHelper2) {
                if (models.containsKey(modelId)) {
                    return true;
                }
                if (!existingFileHelper2.isEnabled()) {
                    return false;
                }
                return existingFileHelper2.exists(modelId, PackType.CLIENT_RESOURCES, ".json", "models");
            }

            private <T> CompletableFuture<?> saveCollection(CachedOutput cache, Map<T, ? extends Supplier<JsonElement>> objectToJsonMap, Function<T, Path> resolveObjectPath) {
                return CompletableFuture.allOf((CompletableFuture[])objectToJsonMap.entrySet().stream().map(entry -> {
                    Path path = (Path)resolveObjectPath.apply(entry.getKey());
                    JsonElement element = (JsonElement)((Supplier)entry.getValue()).get();
                    return DataProvider.saveStable((CachedOutput)cache, (JsonElement)element, (Path)path);
                }).toArray(CompletableFuture[]::new));
            }

            public String getName() {
                return "Model Definitions - " + WoverModelProvider.this.title;
            }
        };
    }

    public static class ModelOverides {
        private final Map<Block, BlockModelProvider> OVERRIDES = new HashMap<Block, BlockModelProvider>();
        private static final BlockModelProvider IGNORE = block -> {};

        public static ModelOverides create() {
            return new ModelOverides();
        }

        public ModelOverides override(@Nullable Block block, @NotNull BlockModelProvider provider) {
            if (block == Blocks.AIR || block == null) {
                return this;
            }
            BlockModelProvider old = this.OVERRIDES.put(block, provider);
            if (old != null) {
                throw new IllegalStateException("Block " + String.valueOf(block) + " already has an override.");
            }
            return this;
        }

        public ModelOverides overrideLike(@Nullable Block block, @NotNull Block copyFromBlock) {
            if (block == Blocks.AIR || block == null) {
                return this;
            }
            return this.override(block, this.OVERRIDES.get(copyFromBlock));
        }

        public ModelOverides ignore(@Nullable Block block) {
            if (block == Blocks.AIR || block == null) {
                return this;
            }
            return this.override(block, IGNORE);
        }

        public boolean contain(Block block) {
            return this.OVERRIDES.containsKey(block);
        }

        boolean provideBlockModel(Block block) {
            BlockModelProvider override = this.OVERRIDES.get(block);
            if (override != null) {
                override.provideModels(block);
                return true;
            }
            return false;
        }

        private ModelOverides() {
        }

        public static interface BlockModelProvider {
            public void provideModels(Block var1);
        }
    }
}

