/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.datagen.api.provider.multi;

import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import org.betterx.wover.core.api.ModCore;
import org.betterx.wover.datagen.api.PackBuilder;
import org.betterx.wover.datagen.api.WoverMultiProvider;
import org.betterx.wover.datagen.api.WoverTagProvider;
import org.betterx.wover.datagen.api.provider.WoverStructurePoolProvider;
import org.betterx.wover.datagen.api.provider.WoverStructureProcessorProvider;
import org.betterx.wover.datagen.api.provider.WoverStructureSetProvider;
import org.betterx.wover.tag.api.event.context.TagBootstrapContext;

public abstract class WoverStructureProvider
implements WoverMultiProvider {
    protected final ModCore modCore;

    public WoverStructureProvider(ModCore modCore) {
        this.modCore = modCore;
    }

    protected abstract void bootstrapSturctures(BootstrapContext<Structure> var1);

    protected abstract void bootstrapSets(BootstrapContext<StructureSet> var1);

    protected abstract void bootstrapPools(BootstrapContext<StructureTemplatePool> var1);

    protected abstract void bootstrapProcessors(BootstrapContext<StructureProcessorList> var1);

    protected abstract void prepareBiomeTags(TagBootstrapContext<Biome> var1);

    @Override
    public void registerAllProviders(PackBuilder pack) {
        pack.addRegistryProvider(modCore -> new org.betterx.wover.datagen.api.provider.WoverStructureProvider(modCore){

            @Override
            protected void bootstrap(BootstrapContext<Structure> context) {
                WoverStructureProvider.this.bootstrapSturctures(context);
            }
        });
        pack.addRegistryProvider(modCore -> new WoverStructureSetProvider(modCore){

            @Override
            protected void bootstrap(BootstrapContext<StructureSet> context) {
                WoverStructureProvider.this.bootstrapSets(context);
            }
        });
        pack.addRegistryProvider(modCore -> new WoverStructurePoolProvider(modCore){

            @Override
            protected void bootstrap(BootstrapContext<StructureTemplatePool> context) {
                WoverStructureProvider.this.bootstrapPools(context);
            }
        });
        pack.addRegistryProvider(modCore -> new WoverStructureProcessorProvider(modCore){

            @Override
            protected void bootstrap(BootstrapContext<StructureProcessorList> context) {
                WoverStructureProvider.this.bootstrapProcessors(context);
            }
        });
        pack.addProvider(modCore -> new WoverTagProvider.ForBiomes(modCore){

            @Override
            protected String getTitle() {
                return "Structure Provider";
            }

            @Override
            public void prepareTags(TagBootstrapContext<Biome> provider) {
                WoverStructureProvider.this.prepareBiomeTags(provider);
            }
        });
    }
}

