/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.datagen.impl;

import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import org.betterx.wover.core.api.ModCore;
import org.betterx.wover.datagen.api.WoverAutoProvider;
import org.betterx.wover.datagen.api.WoverDataProvider;
import org.betterx.wover.datagen.api.WoverTagProvider;
import org.betterx.wover.entrypoint.LibWoverTag;
import org.betterx.wover.tag.api.BlockTagDataProvider;
import org.betterx.wover.tag.api.event.context.TagBootstrapContext;
import org.jetbrains.annotations.Nullable;

public class AutoBlockTagProvider
extends WoverTagProvider.ForBlocks
implements WoverAutoProvider.WithRedirect {
    private final List<WoverTagProvider<Block, TagBootstrapContext<Block>>> redirects = new LinkedList<WoverTagProvider<Block, TagBootstrapContext<Block>>>();

    public AutoBlockTagProvider(ModCore modCore) {
        super(modCore);
    }

    @Override
    public void prepareTags(TagBootstrapContext<Block> provider) {
        this.redirects.forEach(redirect -> {
            LibWoverTag.C.LOG.debug("   {} includes {} for {}", this.getClass().getSimpleName(), redirect.getClass().getSimpleName(), redirect.modCore.namespace);
            redirect.prepareTags(provider);
        });
        BuiltInRegistries.BLOCK.entrySet().stream().filter(entry -> this.modIDs.contains(((ResourceKey)entry.getKey()).location().getNamespace())).forEach(entry -> this.addBlockTags(provider, (ResourceKey<Block>)((ResourceKey)entry.getKey()), (Block)entry.getValue()));
    }

    private void addBlockTags(TagBootstrapContext<Block> provider, ResourceKey<Block> blockKey, Block block) {
        if (block instanceof BlockTagDataProvider) {
            BlockTagDataProvider tagDataProvider = (BlockTagDataProvider)block;
            tagDataProvider.addBlockTags(provider);
        }
        try {
            Method method = block.getClass().getMethod("registerBlockTags", ResourceLocation.class, TagBootstrapContext.class);
            method.invoke((Object)block, blockKey.location(), provider);
        }
        catch (NoSuchMethodException method) {
        }
        catch (Exception e) {
            LibWoverTag.C.LOG.warn("Failed to call registerBlockTags on {}", blockKey.location(), e);
        }
    }

    @Override
    @Nullable
    public <T extends DataProvider> WoverDataProvider<T> redirect(@Nullable WoverDataProvider<T> provider) {
        if (provider instanceof WoverTagProvider) {
            WoverTagProvider tagProvider = (WoverTagProvider)provider;
            if (tagProvider.tagRegistry == this.tagRegistry) {
                LibWoverTag.C.LOG.debug("Redirecting {}  to {} ({})", tagProvider.getClass().getName(), this.getClass().getName(), this.modIDs);
                this.mergeAllowedAndForced(tagProvider);
                this.redirects.add(tagProvider);
                return null;
            }
        }
        return provider;
    }
}

