/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.datagen.impl;

import java.util.LinkedList;
import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import org.betterx.wover.core.api.ModCore;
import org.betterx.wover.datagen.api.WoverAutoProvider;
import org.betterx.wover.datagen.api.WoverDataProvider;
import org.betterx.wover.datagen.api.WoverTagProvider;
import org.betterx.wover.entrypoint.LibWoverTag;
import org.betterx.wover.tag.api.ItemTagDataProvider;
import org.betterx.wover.tag.api.event.context.ItemTagBootstrapContext;
import org.jetbrains.annotations.Nullable;

public class AutoItemTagProvider
extends WoverTagProvider.ForItems
implements WoverAutoProvider.WithRedirect {
    private final List<WoverTagProvider<Item, ItemTagBootstrapContext>> redirects = new LinkedList<WoverTagProvider<Item, ItemTagBootstrapContext>>();

    public AutoItemTagProvider(ModCore modCore) {
        super(modCore);
    }

    @Override
    public void prepareTags(ItemTagBootstrapContext provider) {
        this.redirects.forEach(redirect -> {
            LibWoverTag.C.LOG.debug("   {} includes {} for {}", this.getClass().getSimpleName(), redirect.getClass().getSimpleName(), redirect.modCore.namespace);
            redirect.prepareTags(provider);
        });
        BuiltInRegistries.BLOCK.entrySet().stream().filter(entry -> {
            assert (this.modIDs != null);
            return this.modIDs.contains(((ResourceKey)entry.getKey()).location().getNamespace());
        }).forEach(entry -> this.addBlockItemTags(provider, (ResourceKey<Block>)((ResourceKey)entry.getKey()), (Block)entry.getValue()));
        BuiltInRegistries.ITEM.entrySet().stream().filter(entry -> {
            assert (this.modIDs != null);
            return this.modIDs.contains(((ResourceKey)entry.getKey()).location().getNamespace());
        }).forEach(entry -> this.addItemTags(provider, (ResourceKey<Item>)((ResourceKey)entry.getKey()), (Item)entry.getValue()));
    }

    private void addBlockItemTags(ItemTagBootstrapContext provider, ResourceKey<Block> blockKey, Block block) {
        if (block instanceof ItemTagDataProvider) {
            ItemTagDataProvider tagProvider = (ItemTagDataProvider)block;
            tagProvider.addItemTags(provider);
        }
    }

    private void addItemTags(ItemTagBootstrapContext provider, ResourceKey<Item> itemKey, Item item) {
        if (item instanceof ItemTagDataProvider) {
            ItemTagDataProvider tagProvider = (ItemTagDataProvider)item;
            tagProvider.addItemTags(provider);
        }
    }

    @Override
    @Nullable
    public <T extends DataProvider> WoverDataProvider<T> redirect(@Nullable WoverDataProvider<T> provider) {
        if (provider instanceof WoverTagProvider) {
            WoverTagProvider tagProvider = (WoverTagProvider)provider;
            if (tagProvider.tagRegistry == this.tagRegistry) {
                LibWoverTag.C.LOG.debug("Redirecting {} to {}", tagProvider.getClass().getName(), this.getClass().getName());
                this.mergeAllowedAndForced(tagProvider);
                this.redirects.add(tagProvider);
                return null;
            }
        }
        return provider;
    }
}

