/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.entrypoint.client;

import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.presets.WorldPreset;
import net.minecraft.world.level.levelgen.presets.WorldPresets;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import org.betterx.wover.config.api.client.ClientConfigs;
import org.betterx.wover.core.api.ModCore;
import org.betterx.wover.events.api.client.ClientWorldLifecycle;
import org.betterx.wover.generator.impl.chunkgenerator.ConfiguredChunkGenerator;
import org.betterx.wover.generator.impl.client.WorldSetupScreen;
import org.betterx.wover.preset.api.WorldPresetManager;
import org.betterx.wover.preset.api.client.WorldPresetsUI;

@EventBusSubscriber(modid="wover", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class LibWoverWorldGeneratorClient {
    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent event) {
        ClientWorldLifecycle.AFTER_WELCOME_SCREEN.subscribe(() -> {
            if (((Boolean)ClientConfigs.CLIENT.forceBetterXPreset.get()).booleanValue()) {
                WorldPresetManager.suggestDefault(org.betterx.wover.generator.api.preset.WorldPresets.WOVER_WORLD, 2000);
            } else {
                WorldPresetManager.suggestDefault((ResourceKey<WorldPreset>)WorldPresets.NORMAL, 10000);
            }
        });
        if (ModCore.isClient() && ((Boolean)ClientConfigs.CLIENT.forceBetterXPreset.get()).booleanValue()) {
            WorldPresetManager.suggestDefault(org.betterx.wover.generator.api.preset.WorldPresets.WOVER_WORLD, 2000);
        }
        WorldPresetsUI.registerCustomUI(holder -> {
            if (WorldPresetsUI.isKey((Holder<WorldPreset>)holder, org.betterx.wover.generator.api.preset.WorldPresets.WOVER_WORLD)) {
                return WorldSetupScreen::new;
            }
            for (LevelStem dim : WorldPresetManager.getDimensions((Holder<WorldPreset>)holder).values()) {
                ConfiguredChunkGenerator gen;
                ChunkGenerator patt0$temp = dim.generator();
                if (!(patt0$temp instanceof ConfiguredChunkGenerator) || (gen = (ConfiguredChunkGenerator)patt0$temp).wover_getConfiguredWorldPreset() == null) continue;
                return WorldSetupScreen::new;
            }
            return null;
        });
        WorldPresetsUI.registerCustomUI(org.betterx.wover.generator.api.preset.WorldPresets.WOVER_WORLD_AMPLIFIED, WorldSetupScreen::new);
        WorldPresetsUI.registerCustomUI(org.betterx.wover.generator.api.preset.WorldPresets.WOVER_WORLD_LARGE, WorldSetupScreen::new);
    }
}

