/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.events.mixin;

import com.mojang.datafixers.DataFixer;
import java.net.Proxy;
import net.minecraft.core.LayeredRegistryAccess;
import net.minecraft.core.RegistryAccess;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.RegistryLayer;
import net.minecraft.server.Services;
import net.minecraft.server.WorldStem;
import net.minecraft.server.level.progress.ChunkProgressListener;
import net.minecraft.server.level.progress.ChunkProgressListenerFactory;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.storage.WorldData;
import org.betterx.wover.events.api.types.OnRegistryReady;
import org.betterx.wover.events.impl.WorldLifecycleImpl;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={MinecraftServer.class}, priority=150)
public class MinecraftServerMixin {
    @Shadow
    @Final
    private LayeredRegistryAccess<RegistryLayer> registries;
    @Shadow
    @Final
    protected LevelStorageSource.LevelStorageAccess storageSource;
    @Shadow
    @Final
    private PackRepository packRepository;
    @Shadow
    @Final
    protected WorldData worldData;

    @Inject(at={@At(value="RETURN")}, method={"<init>"})
    private void wover_initMinecraftServerLate(Thread thread, LevelStorageSource.LevelStorageAccess levelStorageAccess, PackRepository packRepository, WorldStem worldStem, Proxy proxy, DataFixer dataFixer, Services services, ChunkProgressListenerFactory chunkProgressListenerFactory, CallbackInfo ci) {
        WorldLifecycleImpl.WORLD_REGISTRY_READY.emit((RegistryAccess)worldStem.registries().compositeAccess(), OnRegistryReady.Stage.FINAL);
        WorldLifecycleImpl.WORLD_FOLDER_READY.emit(levelStorageAccess);
        WorldLifecycleImpl.MINECRAFT_SERVER_READY.emit(c -> c.notify(levelStorageAccess, packRepository, worldStem));
    }

    @Inject(method={"createLevels"}, at={@At(value="HEAD")})
    private void wover_biomesReady(ChunkProgressListener worldGenerationProgressListener, CallbackInfo ci) {
        WorldLifecycleImpl.WORLD_REGISTRY_READY.emit((RegistryAccess)this.registries.compositeAccess(), OnRegistryReady.Stage.FINAL);
        WorldLifecycleImpl.WORLD_FOLDER_READY.emit(this.storageSource);
        WorldLifecycleImpl.BEFORE_CREATING_LEVELS.emit(c -> c.notify(this.storageSource, this.packRepository, this.registries, this.worldData));
    }
}

