/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.feature.api.configured;

import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import org.betterx.wover.events.api.Event;
import org.betterx.wover.events.api.types.OnBootstrapRegistry;
import org.betterx.wover.feature.api.configured.ConfiguredFeatureKey;
import org.betterx.wover.feature.api.configured.configurators.AsBlockColumn;
import org.betterx.wover.feature.api.configured.configurators.AsMultiPlaceRandomSelect;
import org.betterx.wover.feature.api.configured.configurators.AsOre;
import org.betterx.wover.feature.api.configured.configurators.AsPillar;
import org.betterx.wover.feature.api.configured.configurators.AsRandomSelect;
import org.betterx.wover.feature.api.configured.configurators.AsSequence;
import org.betterx.wover.feature.api.configured.configurators.FacingBlock;
import org.betterx.wover.feature.api.configured.configurators.ForSimpleBlock;
import org.betterx.wover.feature.api.configured.configurators.NetherForrestVegetation;
import org.betterx.wover.feature.api.configured.configurators.RandomPatch;
import org.betterx.wover.feature.api.configured.configurators.WeightedBlock;
import org.betterx.wover.feature.api.configured.configurators.WeightedBlockPatch;
import org.betterx.wover.feature.api.configured.configurators.WithConfiguration;
import org.betterx.wover.feature.api.configured.configurators.WithTemplates;
import org.betterx.wover.feature.impl.configured.AsBlockColumnImpl;
import org.betterx.wover.feature.impl.configured.AsMultiPlaceRandomSelectImpl;
import org.betterx.wover.feature.impl.configured.AsOreImpl;
import org.betterx.wover.feature.impl.configured.AsPillarImpl;
import org.betterx.wover.feature.impl.configured.AsRandomSelectImpl;
import org.betterx.wover.feature.impl.configured.AsSequenceImpl;
import org.betterx.wover.feature.impl.configured.FacingBlockImpl;
import org.betterx.wover.feature.impl.configured.FeatureConfiguratorImpl;
import org.betterx.wover.feature.impl.configured.ForSimpleBlockImpl;
import org.betterx.wover.feature.impl.configured.InlineBuilderImpl;
import org.betterx.wover.feature.impl.configured.NetherForrestVegetationImpl;
import org.betterx.wover.feature.impl.configured.RandomPatchImpl;
import org.betterx.wover.feature.impl.configured.WeightedBlockImpl;
import org.betterx.wover.feature.impl.configured.WeightedBlockPatchImpl;
import org.betterx.wover.feature.impl.configured.WithConfigurationImpl;
import org.betterx.wover.feature.impl.configured.WithTemplatesImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ConfiguredFeatureManager {
    public static final Event<OnBootstrapRegistry<ConfiguredFeature<?, ?>>> BOOTSTRAP_CONFIGURED_FEATURES = FeatureConfiguratorImpl.BOOTSTRAP_CONFIGURED_FEATURES;
    public static final InlineBuilder INLINE_BUILDER = new InlineBuilderImpl();

    public static ConfiguredFeatureKey<ForSimpleBlock> simple(ResourceLocation id) {
        return new ForSimpleBlockImpl.Key(id);
    }

    public static ConfiguredFeatureKey<RandomPatch> randomPatch(ResourceLocation id) {
        return new RandomPatchImpl.Key(id);
    }

    public static ConfiguredFeatureKey<AsOre> ore(ResourceLocation id) {
        return new AsOreImpl.Key(id);
    }

    public static ConfiguredFeatureKey<AsPillar> pillar(ResourceLocation id) {
        return new AsPillarImpl.Key(id);
    }

    public static ConfiguredFeatureKey<AsSequence> sequence(ResourceLocation id) {
        return new AsSequenceImpl.Key(id);
    }

    public static ConfiguredFeatureKey<AsBlockColumn> blockColumn(ResourceLocation id) {
        return new AsBlockColumnImpl.Key(id);
    }

    public static ConfiguredFeatureKey<WithTemplates> templates(ResourceLocation id) {
        return new WithTemplatesImpl.Key(id);
    }

    public static ConfiguredFeatureKey<NetherForrestVegetation> netherForrestVegetation(ResourceLocation id) {
        return new NetherForrestVegetationImpl.Key(id);
    }

    public static <F extends Feature<FC>, FC extends FeatureConfiguration> ConfiguredFeatureKey<WithConfiguration<F, FC>> configuration(ResourceLocation id, F feature) {
        return new WithConfigurationImpl.Key(id, feature);
    }

    public static ConfiguredFeatureKey<FacingBlock> facingBlock(ResourceLocation id) {
        return new FacingBlockImpl.Key(id);
    }

    public static ConfiguredFeatureKey<WeightedBlockPatch> randomBlockPatch(ResourceLocation id) {
        return new WeightedBlockPatchImpl.Key(id);
    }

    public static ConfiguredFeatureKey<WeightedBlockPatch> bonemeal(ResourceLocation id) {
        return new WeightedBlockPatchImpl.KeyBonemeal(id);
    }

    public static ConfiguredFeatureKey<NetherForrestVegetation> bonemealNetherForrest(ResourceLocation id) {
        return new NetherForrestVegetationImpl.KeyBonemeal(id);
    }

    public static ConfiguredFeatureKey<WeightedBlock> randomBlock(ResourceLocation id) {
        return new WeightedBlockImpl.Key(id);
    }

    public static ConfiguredFeatureKey<AsRandomSelect> randomFeature(ResourceLocation id) {
        return new AsRandomSelectImpl.Key(id);
    }

    public static ConfiguredFeatureKey<AsMultiPlaceRandomSelect> multiPlaceRandomFeature(ResourceLocation id) {
        return new AsMultiPlaceRandomSelectImpl.Key(id);
    }

    @Nullable
    public static Holder<ConfiguredFeature<?, ?>> getHolder(@Nullable HolderGetter<ConfiguredFeature<?, ?>> getter, @NotNull ResourceKey<ConfiguredFeature<?, ?>> key) {
        return FeatureConfiguratorImpl.getHolder(getter, key);
    }

    @Nullable
    public static Holder<ConfiguredFeature<?, ?>> getHolder(@Nullable BootstrapContext<?> context, @NotNull ResourceKey<ConfiguredFeature<?, ?>> key) {
        return ConfiguredFeatureManager.getHolder(context.lookup(Registries.CONFIGURED_FEATURE), key);
    }

    private ConfiguredFeatureManager() {
    }

    public static interface InlineBuilder {
        public AsOre ore();

        public AsPillar pillar();

        public AsSequence sequence();

        public AsBlockColumn blockColumn();

        public WithTemplates templates();

        public NetherForrestVegetation netherForrestVegetation();

        public <F extends Feature<FC>, FC extends FeatureConfiguration> WithConfiguration<F, FC> withFeature(F var1);

        @Deprecated(forRemoval=true)
        default public <F extends Feature<FC>, FC extends FeatureConfiguration> WithConfiguration<F, FC> configuration(F feature) {
            return this.withFeature(feature);
        }

        public FacingBlock facingBlock();

        public WeightedBlockPatch randomBlockPatch();

        public WeightedBlockPatch bonemealPatch();

        public WeightedBlock randomBlock();

        public AsRandomSelect randomFeature();

        public AsMultiPlaceRandomSelect multiPlaceRandomFeature();

        public ForSimpleBlock simple();

        public RandomPatch randomPatch();
    }
}

