/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.feature.api.placed.modifiers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.placement.PlacementContext;
import net.minecraft.world.level.levelgen.placement.PlacementFilter;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;
import org.betterx.wover.feature.impl.placed.modifiers.PlacementModifiersImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IsBasin
extends PlacementFilter {
    public static final MapCodec<IsBasin> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BlockPredicate.CODEC.fieldOf("predicate").forGetter(cfg -> cfg.predicate), (App)BlockPredicate.CODEC.optionalFieldOf("top_predicate").forGetter(cfg -> Optional.ofNullable(cfg.topPredicate))).apply((Applicative)instance, IsBasin::new));
    @NotNull
    private final BlockPredicate predicate;
    @Nullable
    private final BlockPredicate topPredicate;

    private IsBasin(@NotNull BlockPredicate predicate, @NotNull Optional<BlockPredicate> topPredicate) {
        this(predicate, (BlockPredicate)topPredicate.orElse(null));
    }

    private IsBasin(@NotNull BlockPredicate predicate, @Nullable BlockPredicate topPredicate) {
        this.predicate = predicate;
        this.topPredicate = topPredicate;
    }

    public static PlacementFilter simple(BlockPredicate predicate) {
        return new IsBasin(predicate, (BlockPredicate)null);
    }

    public static IsBasin openTop(BlockPredicate predicate) {
        return new IsBasin(predicate, BlockPredicate.ONLY_IN_AIR_PREDICATE);
    }

    protected boolean shouldPlace(PlacementContext ctx, RandomSource random, BlockPos pos) {
        WorldGenLevel level = ctx.getLevel();
        if (this.topPredicate != null && !this.topPredicate.test((Object)level, (Object)pos.above())) {
            return false;
        }
        return this.predicate.test((Object)level, (Object)pos.below()) && this.predicate.test((Object)level, (Object)pos.west()) && this.predicate.test((Object)level, (Object)pos.east()) && this.predicate.test((Object)level, (Object)pos.north()) && this.predicate.test((Object)level, (Object)pos.south());
    }

    @NotNull
    public PlacementModifierType<?> type() {
        return PlacementModifiersImpl.IS_BASIN;
    }
}

