/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.feature.impl.placed.modifiers;

import com.mojang.serialization.MapCodec;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;
import net.neoforged.neoforge.registries.RegisterEvent;
import org.betterx.wover.entrypoint.LibWoverFeature;
import org.betterx.wover.feature.api.placed.modifiers.All;
import org.betterx.wover.feature.api.placed.modifiers.Debug;
import org.betterx.wover.feature.api.placed.modifiers.EveryLayer;
import org.betterx.wover.feature.api.placed.modifiers.Extend;
import org.betterx.wover.feature.api.placed.modifiers.ExtendXYZ;
import org.betterx.wover.feature.api.placed.modifiers.FindInDirection;
import org.betterx.wover.feature.api.placed.modifiers.InBiome;
import org.betterx.wover.feature.api.placed.modifiers.Is;
import org.betterx.wover.feature.api.placed.modifiers.IsBasin;
import org.betterx.wover.feature.api.placed.modifiers.IsNextTo;
import org.betterx.wover.feature.api.placed.modifiers.Merge;
import org.betterx.wover.feature.api.placed.modifiers.NoiseFilter;
import org.betterx.wover.feature.api.placed.modifiers.Offset;
import org.betterx.wover.feature.api.placed.modifiers.OffsetProvider;
import org.betterx.wover.feature.api.placed.modifiers.Stencil;
import org.betterx.wover.legacy.api.LegacyHelper;
import org.jetbrains.annotations.ApiStatus;

public class PlacementModifiersImpl {
    private static final Map<ResourceLocation, PlacementModifierType<?>> TYPES = new LinkedHashMap();
    private static final Map<ResourceLocation, PlacementModifierType<?>> LEGACY_TYPES = new LinkedHashMap();
    public static PlacementModifierType<Stencil> STENCIL = PlacementModifiersImpl.registerLegacy("stencil", Stencil.CODEC);
    public static PlacementModifierType<IsNextTo> IS_NEXT_TO = PlacementModifiersImpl.registerLegacy("is_next_to", IsNextTo.CODEC);
    public static PlacementModifierType<NoiseFilter> NOISE_FILTER = PlacementModifiersImpl.registerLegacy("noise_filter", NoiseFilter.CODEC);
    public static PlacementModifierType<Debug> DEBUG = PlacementModifiersImpl.registerLegacy("debug", Debug.CODEC);
    public static PlacementModifierType<Merge> FOR_ALL = PlacementModifiersImpl.registerLegacy("for_all", Merge.CODEC);
    public static PlacementModifierType<FindInDirection> SOLID_IN_DIR = PlacementModifiersImpl.registerLegacy("solid_in_dir", FindInDirection.CODEC);
    public static PlacementModifierType<All> ALL = PlacementModifiersImpl.registerLegacy("all", All.CODEC);
    public static PlacementModifierType<IsBasin> IS_BASIN = PlacementModifiersImpl.registerLegacy("is_basin", IsBasin.CODEC);
    public static PlacementModifierType<Is> IS = PlacementModifiersImpl.registerLegacy("is", Is.CODEC);
    public static PlacementModifierType<Offset> OFFSET = PlacementModifiersImpl.registerLegacy("offset", Offset.CODEC);
    public static PlacementModifierType<OffsetProvider> OFFSET_PROVIDER = PlacementModifiersImpl.register("offset_provider", OffsetProvider.CODEC);
    public static PlacementModifierType<Extend> EXTEND = PlacementModifiersImpl.registerLegacy("extend", Extend.CODEC);
    public static PlacementModifierType<InBiome> IN_BIOME = PlacementModifiersImpl.registerLegacy("in_biome", InBiome.CODEC);
    public static PlacementModifierType<ExtendXYZ> EXTEND_XZ = PlacementModifiersImpl.register("extend_xyz", ExtendXYZ.CODEC);
    public static PlacementModifierType<EveryLayer> EVERY_LAYER = PlacementModifiersImpl.register("every_layer", EveryLayer.CODEC);

    private static <P extends PlacementModifier> PlacementModifierType<P> registerLegacy(String path, MapCodec<P> codec) {
        ResourceLocation id = LibWoverFeature.C.id(path);
        return PlacementModifiersImpl.register(id, codec, true);
    }

    private static <P extends PlacementModifier> PlacementModifierType<P> register(String path, MapCodec<P> codec) {
        ResourceLocation id = LibWoverFeature.C.id(path);
        return PlacementModifiersImpl.register(id, codec, false);
    }

    public static <P extends PlacementModifier> PlacementModifierType<P> register(ResourceLocation location, MapCodec<P> codec, boolean withLegacyBCLib) {
        PlacementModifierType res = () -> codec;
        TYPES.put(location, res);
        if (withLegacyBCLib && LegacyHelper.isLegacyEnabled()) {
            PlacementModifierType legacy = () -> codec;
            LEGACY_TYPES.put(LegacyHelper.BCLIB_CORE.convertNamespace(location), legacy);
        }
        return res;
    }

    @ApiStatus.Internal
    public static void ensureStaticInitialization() {
    }

    public static void register(RegisterEvent event) {
        if (event.getRegistryKey().equals(Registries.PLACEMENT_MODIFIER_TYPE)) {
            event.register(Registries.PLACEMENT_MODIFIER_TYPE, (T helper) -> {
                TYPES.forEach((arg_0, arg_1) -> ((RegisterEvent.RegisterHelper)helper).register(arg_0, arg_1));
                LEGACY_TYPES.forEach((arg_0, arg_1) -> ((RegisterEvent.RegisterHelper)helper).register(arg_0, arg_1));
            });
        }
    }

    static {
        if (LegacyHelper.isLegacyEnabled()) {
            PlacementModifiersImpl.register(LegacyHelper.BCLIB_CORE.id("on_every_layer"), EveryLayer.CODEC, false);
            PlacementModifiersImpl.register(LegacyHelper.BCLIB_CORE.id("under_every_layer"), EveryLayer.CODEC_LEGACY_UNDER, false);
        }
    }
}

