/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.poi.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.core.LayeredRegistryAccess;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.RegistryLayer;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.storage.WorldData;
import org.betterx.wover.events.api.WorldLifecycle;
import org.betterx.wover.poi.api.PoiTypeExtension;
import org.betterx.wover.poi.api.WoverPoiType;
import org.betterx.wover.state.api.WorldState;
import org.betterx.wover.tag.api.predefined.CommonPoiTags;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class PoiManagerImpl {
    private static final List<Holder<PoiType>> TYPES_WITH_TAGS = new ArrayList<Holder<PoiType>>(20);
    private static Map<BlockState, Holder<PoiType>> ORIGINAL_BLOCK_STATES = null;

    public static WoverPoiType register(ResourceLocation location, Set<BlockState> matchingStates, int maxTickets, int validRanges, @Nullable TagKey<Block> tag) {
        ResourceKey key = ResourceKey.create((ResourceKey)Registries.POINT_OF_INTEREST_TYPE, (ResourceLocation)location);
        PoiType type = PoiTypes.register((Registry)BuiltInRegistries.POINT_OF_INTEREST_TYPE, (ResourceKey)key, matchingStates, (int)maxTickets, (int)validRanges);
        WoverPoiType woverType = new WoverPoiType((ResourceKey<PoiType>)key, type, matchingStates, maxTickets, validRanges);
        if (tag != null) {
            woverType.setTag(tag);
        }
        return woverType;
    }

    public static void setTag(ResourceKey<PoiType> type, TagKey<Block> tag) {
        Optional oHolder = BuiltInRegistries.POINT_OF_INTEREST_TYPE.getHolder(type);
        if (oHolder.isPresent()) {
            PoiManagerImpl.setTag((PoiType)((Holder.Reference)oHolder.get()).value(), tag);
            PoiManagerImpl.didAddTagFor((Holder<PoiType>)((Holder)oHolder.get()), tag);
        }
    }

    private static void setTag(PoiType type, TagKey<Block> tag) {
        PoiType poiType = type;
        if (poiType instanceof PoiTypeExtension) {
            PoiTypeExtension ext = (PoiTypeExtension)poiType;
            ext.wover_setTag(tag);
        }
    }

    @ApiStatus.Internal
    public static void registerAll() {
        PoiManagerImpl.setTag((ResourceKey<PoiType>)PoiTypes.ARMORER, CommonPoiTags.ARMORER_WORKSTATION);
        PoiManagerImpl.setTag((ResourceKey<PoiType>)PoiTypes.BUTCHER, CommonPoiTags.BUTCHER_WORKSTATION);
        PoiManagerImpl.setTag((ResourceKey<PoiType>)PoiTypes.CARTOGRAPHER, CommonPoiTags.CARTOGRAPHER_WORKSTATION);
        PoiManagerImpl.setTag((ResourceKey<PoiType>)PoiTypes.CLERIC, CommonPoiTags.CLERIC_WORKSTATION);
        PoiManagerImpl.setTag((ResourceKey<PoiType>)PoiTypes.FARMER, CommonPoiTags.FARMER_WORKSTATION);
        PoiManagerImpl.setTag((ResourceKey<PoiType>)PoiTypes.FISHERMAN, CommonPoiTags.FISHERMAN_WORKSTATION);
        PoiManagerImpl.setTag((ResourceKey<PoiType>)PoiTypes.FLETCHER, CommonPoiTags.FLETCHER_WORKSTATION);
        PoiManagerImpl.setTag((ResourceKey<PoiType>)PoiTypes.LEATHERWORKER, CommonPoiTags.LEATHERWORKER_WORKSTATION);
        PoiManagerImpl.setTag((ResourceKey<PoiType>)PoiTypes.LIBRARIAN, CommonPoiTags.LIBRARIAN_WORKSTATION);
        PoiManagerImpl.setTag((ResourceKey<PoiType>)PoiTypes.MASON, CommonPoiTags.MASON_WORKSTATION);
        PoiManagerImpl.setTag((ResourceKey<PoiType>)PoiTypes.SHEPHERD, CommonPoiTags.SHEPHERD_WORKSTATION);
        PoiManagerImpl.setTag((ResourceKey<PoiType>)PoiTypes.TOOLSMITH, CommonPoiTags.TOOLSMITH_WORKSTATION);
        PoiManagerImpl.setTag((ResourceKey<PoiType>)PoiTypes.WEAPONSMITH, CommonPoiTags.WEAPONSMITH_WORKSTATION);
        PoiManagerImpl.setTag((ResourceKey<PoiType>)PoiTypes.HOME, CommonPoiTags.HOME);
        PoiManagerImpl.setTag((ResourceKey<PoiType>)PoiTypes.MEETING, CommonPoiTags.MEETING_PLACE);
        PoiManagerImpl.setTag((ResourceKey<PoiType>)PoiTypes.BEEHIVE, CommonPoiTags.BEEHIVE);
        PoiManagerImpl.setTag((ResourceKey<PoiType>)PoiTypes.BEE_NEST, CommonPoiTags.BEE_NEST);
        PoiManagerImpl.setTag((ResourceKey<PoiType>)PoiTypes.NETHER_PORTAL, CommonPoiTags.NETHER_PORTAL);
        PoiManagerImpl.setTag((ResourceKey<PoiType>)PoiTypes.LODESTONE, CommonPoiTags.LODESTONE);
        PoiManagerImpl.setTag((ResourceKey<PoiType>)PoiTypes.LIGHTNING_ROD, CommonPoiTags.LIGHTNING_ROD);
        WorldLifecycle.BEFORE_CREATING_LEVELS.subscribe(PoiManagerImpl::finalizedWorldLoad, 99999999);
    }

    private static void finalizedWorldLoad(LevelStorageSource.LevelStorageAccess levelStorageAccess, PackRepository packRepository, LayeredRegistryAccess<RegistryLayer> registryLayerLayeredRegistryAccess, WorldData worldData) {
        PoiManagerImpl.updateStates();
    }

    private static void didAddTagFor(Holder<PoiType> type, TagKey<Block> tag) {
        TYPES_WITH_TAGS.remove(type);
        if (tag != null) {
            TYPES_WITH_TAGS.add(type);
        }
    }

    @ApiStatus.Internal
    public static void updateStates() {
        if (ORIGINAL_BLOCK_STATES == null) {
            ORIGINAL_BLOCK_STATES = new HashMap<BlockState, Holder<PoiType>>(PoiTypes.TYPE_BY_STATE);
        } else {
            PoiTypes.TYPE_BY_STATE.clear();
            PoiTypes.TYPE_BY_STATE.putAll(ORIGINAL_BLOCK_STATES);
        }
        for (Holder<PoiType> type : TYPES_WITH_TAGS) {
            PoiTypeExtension ex;
            TagKey<Block> tag;
            Object object = type.value();
            if (!(object instanceof PoiTypeExtension) || (tag = (ex = (PoiTypeExtension)object).wover_getTag()) == null) continue;
            Registry registry = WorldState.registryAccess().registryOrThrow(tag.registry());
            for (Holder block : registry.getTagOrEmpty(tag)) {
                for (BlockState state : ((Block)block.value()).getStateDefinition().getPossibleStates()) {
                    PoiTypes.TYPE_BY_STATE.put(state, type);
                }
            }
        }
    }
}

