/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.preset.impl;

import net.minecraft.core.Holder;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.levelgen.presets.WorldPreset;
import org.betterx.wover.preset.api.WorldPresetInfo;
import org.betterx.wover.preset.api.WorldPresetInfoBuilder;
import org.betterx.wover.preset.impl.WorldPresetInfoImpl;
import org.betterx.wover.preset.impl.WorldPresetInfoRegistryImpl;
import org.betterx.wover.util.PriorityLinkedList;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class WorldPresetInfoBuilderImpl
implements WorldPresetInfoBuilder {
    private int sortOrder = PriorityLinkedList.DEFAULT_PRIORITY;
    @Nullable
    private ResourceKey<WorldPreset> overworldLike;
    @Nullable
    private ResourceKey<WorldPreset> netherLike;
    @Nullable
    private ResourceKey<WorldPreset> endLike;
    private final BootstrapContext<WorldPresetInfo> context;

    @ApiStatus.Internal
    public WorldPresetInfoBuilderImpl(BootstrapContext<WorldPresetInfo> context) {
        this.context = context;
    }

    @Override
    public WorldPresetInfoBuilder order(int order) {
        this.sortOrder = order;
        return this;
    }

    @Override
    public WorldPresetInfoBuilder overworldOverride(ResourceKey<WorldPreset> overworldLike) {
        this.overworldLike = overworldLike;
        return this;
    }

    @Override
    public WorldPresetInfoBuilder netherOverride(ResourceKey<WorldPreset> netherLike) {
        this.netherLike = netherLike;
        return this;
    }

    @Override
    public WorldPresetInfoBuilder endOverride(ResourceKey<WorldPreset> endLike) {
        this.endLike = endLike;
        return this;
    }

    @Override
    public WorldPresetInfo build() {
        return new WorldPresetInfoImpl(this.sortOrder, this.overworldLike, this.netherLike, this.endLike);
    }

    @Override
    public Holder<WorldPresetInfo> register(ResourceKey<WorldPreset> key) {
        return WorldPresetInfoRegistryImpl.register(this.context, key, this.build());
    }
}

