/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.preset.mixin.client;

import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import java.util.OptionalLong;
import net.minecraft.client.gui.screens.worldselection.PresetEditor;
import net.minecraft.client.gui.screens.worldselection.WorldCreationContext;
import net.minecraft.client.gui.screens.worldselection.WorldCreationUiState;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.levelgen.presets.WorldPreset;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.betterx.wover.preset.impl.client.WorldPresetsClientImpl;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@OnlyIn(value=Dist.CLIENT)
@Mixin(value={WorldCreationUiState.class})
public abstract class WorldCreationUIStateMixin {
    @Shadow
    @Final
    private List<WorldCreationUiState.WorldTypeEntry> normalPresetList;

    @Shadow
    public abstract WorldCreationUiState.WorldTypeEntry getWorldType();

    @Shadow
    public abstract void setWorldType(WorldCreationUiState.WorldTypeEntry var1);

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void wover_updateDimensions(Path path, WorldCreationContext worldCreationContext, Optional<ResourceKey<WorldPreset>> worldPreset, OptionalLong seed, CallbackInfo ci) {
        worldPreset.flatMap(worldPresetResourceKey -> this.normalPresetList.stream().filter(p -> p.preset() != null).filter(p -> p.preset().unwrapKey().isPresent()).filter(p -> ((ResourceKey)p.preset().unwrapKey().orElseThrow()).equals(worldPresetResourceKey)).findAny()).ifPresent(this::setWorldType);
    }

    @Inject(method={"getPresetEditor"}, at={@At(value="HEAD")}, cancellable=true)
    private void wover_getPresetEditor(CallbackInfoReturnable<PresetEditor> cir) {
        PresetEditor editor = WorldPresetsClientImpl.getSetupScreenForPreset((Holder<WorldPreset>)this.getWorldType().preset());
        if (editor != null) {
            cir.setReturnValue((Object)editor);
        }
    }
}

