/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.recipe.impl;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import org.betterx.wover.recipe.api.BaseRecipeBuilder;
import org.betterx.wover.recipe.impl.WoverRecipeProviderAccess;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseRecipeBuilderImpl<I extends BaseRecipeBuilder<I>>
implements BaseRecipeBuilder<I> {
    protected RecipeCategory category;
    protected String group;
    protected boolean shouldUnlockAdvancements;
    @NotNull
    protected final ItemStack output;
    @NotNull
    protected final ResourceLocation id;
    protected final Map<String, Criterion<?>> unlocks;
    protected Ingredient ingredient;
    protected int experience;
    protected int cookingTime;

    protected BaseRecipeBuilderImpl(@NotNull ResourceLocation id, @NotNull ItemLike output) {
        this(id, new ItemStack(output, 1));
    }

    protected BaseRecipeBuilderImpl(@NotNull ResourceLocation id, @NotNull ItemStack output) {
        this.id = id;
        this.category = RecipeCategory.MISC;
        this.output = output;
        this.unlocks = new HashMap();
        this.shouldUnlockAdvancements = true;
    }

    public I shouldUnlockAdvancements(boolean shouldUnlockAdvancements) {
        this.shouldUnlockAdvancements = shouldUnlockAdvancements;
        return (I)this;
    }

    public I outputCount(int count) {
        this.output.setCount(count);
        return (I)this;
    }

    @Override
    public I category(@NotNull RecipeCategory category) {
        this.category = category;
        return (I)this;
    }

    public I group(@Nullable String group) {
        this.group = group;
        return (I)this;
    }

    public I unlocks(String name, Criterion<?> criterion) {
        this.unlocks.put(name, criterion);
        return (I)this;
    }

    public I unlockedBy(ItemLike item) {
        this.unlocks("has_" + item.asItem().getDescriptionId(), WoverRecipeProviderAccess.has((ItemLike)item.asItem()));
        return (I)this;
    }

    public I unlockedBy(TagKey<Item> tag) {
        this.unlocks("has_tag_" + tag.location().getNamespace() + "_" + tag.location().getPath(), WoverRecipeProviderAccess.has(tag));
        return (I)this;
    }

    public I unlockedBy(ItemLike ... items) {
        Object name = "has_" + Arrays.stream(items).map(block -> block instanceof Block ? BuiltInRegistries.BLOCK.getKey((Object)((Block)block)) : BuiltInRegistries.ITEM.getKey((Object)((Item)block))).filter(id -> id != null).map(id -> id.getPath()).collect(Collectors.joining("_"));
        if (((String)name).length() > 45) {
            name = ((String)name).substring(0, 42);
        }
        return this.unlocks((String)name, items);
    }

    public I unlocks(String name, ItemLike ... items) {
        return this.unlocks(name, InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])items));
    }

    public I unlockedBy(ItemStack ... stacks) {
        ItemLike[] items = (ItemLike[])Arrays.stream(stacks).filter(stack -> stack.getCount() > 0).map(stack -> stack.getItem()).toArray(ItemLike[]::new);
        return this.unlockedBy(items);
    }

    protected void throwIllegalStateException(String message) {
        throw new IllegalStateException(message + "(" + String.valueOf(this.id) + ")");
    }

    protected void validate() {
        if (this.output.getCount() <= 0) {
            this.throwIllegalStateException("Output-Count is zero");
        }
        if (this.category == null) {
            this.throwIllegalStateException("Category is not set");
        }
    }
}

