/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.recipe.impl;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.Map;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.neoforged.neoforge.common.conditions.ICondition;
import org.betterx.wover.events.impl.EventImpl;
import org.betterx.wover.recipe.api.OnBootstrapRecipes;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RecipeRuntimeProviderImpl {
    public static final EventImpl<OnBootstrapRecipes> BOOTSTRAP_RECIPES = new EventImpl("BOOTSTRAP_RECIPES");

    @ApiStatus.Internal
    public static LoadedRecipes loadedRecipes(final LoadedRecipes loaded) {
        final boolean[] didInit = new boolean[]{false};
        final ImmutableMultimap.Builder typeBuilder = ImmutableMultimap.builder();
        final ImmutableMap.Builder nameBuilder = ImmutableMap.builder();
        RecipeOutput context = new RecipeOutput(){

            public void accept(ResourceLocation resourceLocation, Recipe<?> recipe, @Nullable AdvancementHolder advancementHolder) {
                if (!didInit[0]) {
                    typeBuilder.putAll(loaded.byType);
                    nameBuilder.putAll(loaded.byName);
                    didInit[0] = true;
                }
                RecipeHolder recipeHolder = new RecipeHolder(resourceLocation, recipe);
                typeBuilder.put((Object)recipe.getType(), (Object)recipeHolder);
                nameBuilder.put((Object)resourceLocation, (Object)recipeHolder);
            }

            public void accept(ResourceLocation resourceLocation, Recipe<?> recipe, @Nullable AdvancementHolder advancementHolder, ICondition ... conditions) {
                this.accept(resourceLocation, recipe, advancementHolder);
            }

            public // Could not load outer class - annotation placement on inner may be incorrect
             @NotNull Advancement.Builder advancement() {
                return Advancement.Builder.recipeAdvancement().parent(RecipeBuilder.ROOT_RECIPE_ADVANCEMENT);
            }
        };
        BOOTSTRAP_RECIPES.emit(c -> c.bootstrap(context));
        if (!didInit[0]) {
            return loaded;
        }
        return new LoadedRecipes((Multimap<RecipeType<?>, RecipeHolder<?>>)typeBuilder.build(), (Map<ResourceLocation, RecipeHolder<?>>)nameBuilder.build());
    }

    public record LoadedRecipes(Multimap<RecipeType<?>, RecipeHolder<?>> byType, Map<ResourceLocation, RecipeHolder<?>> byName) {
    }
}

