/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.recipe.impl;

import java.util.Map;
import net.minecraft.advancements.Criterion;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.SmithingTransformRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.SmithingTemplateItem;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.betterx.wover.recipe.api.SmithingRecipeBuilder;
import org.betterx.wover.recipe.impl.BaseRecipeBuilderImpl;
import org.jetbrains.annotations.NotNull;

public class SmithingRecipeBuilderImpl
extends BaseRecipeBuilderImpl<SmithingRecipeBuilder>
implements SmithingRecipeBuilder {
    protected Ingredient template;
    protected Ingredient base;
    protected Ingredient addon;

    public SmithingRecipeBuilderImpl(@NotNull ResourceLocation id, @NotNull ItemLike output) {
        super(id, output);
    }

    @Override
    public SmithingRecipeBuilderImpl template(SmithingTemplateItem in) {
        this.template = Ingredient.of((ItemLike[])new ItemLike[]{in});
        this.unlockedBy((ItemLike)in);
        return this;
    }

    @Override
    public SmithingRecipeBuilderImpl base(TagKey<Item> in) {
        this.base = Ingredient.of(in);
        return this;
    }

    @Override
    public SmithingRecipeBuilderImpl base(ItemLike in) {
        this.base = Ingredient.of((ItemLike[])new ItemLike[]{in});
        return this;
    }

    @Override
    public SmithingRecipeBuilderImpl base(Ingredient in) {
        this.base = in;
        return this;
    }

    @Override
    public SmithingRecipeBuilderImpl addon(TagKey<Item> in) {
        this.addon = Ingredient.of(in);
        return this;
    }

    @Override
    public SmithingRecipeBuilderImpl addon(ItemLike in) {
        this.addon = Ingredient.of((ItemLike[])new ItemLike[]{in});
        return this;
    }

    @Override
    public SmithingRecipeBuilderImpl addon(Ingredient in) {
        this.addon = in;
        return this;
    }

    @Override
    protected void validate() {
        super.validate();
        if (this.template == null) {
            this.throwIllegalStateException("Template must be set");
        }
        if (this.base == null) {
            this.throwIllegalStateException("Base must be set");
        }
        if (this.addon == null) {
            this.throwIllegalStateException("Addon must be set");
        }
        if (this.output.getCount() != 1) {
            this.throwIllegalStateException("Output count must be 1");
        }
    }

    @Override
    public void build(RecipeOutput ctx) {
        SmithingTransformRecipeBuilder builder = SmithingTransformRecipeBuilder.smithing((Ingredient)this.template, (Ingredient)this.base, (Ingredient)this.addon, (RecipeCategory)this.category, (Item)this.output.getItem());
        for (Map.Entry item : this.unlocks.entrySet()) {
            builder.unlocks((String)item.getKey(), (Criterion)item.getValue());
        }
        builder.save(ctx, this.id);
    }
}

