/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.structure.api.structures.nbt;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.TemplateStructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockIgnoreProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import org.betterx.wover.structure.impl.StructureManagerImpl;

public class RandomNbtStructurePiece
extends TemplateStructurePiece {
    private final boolean keepAir;

    public RandomNbtStructurePiece(StructureTemplateManager manager, ResourceLocation nbtLocation, StructurePlaceSettings placeSettings, BlockPos templatePosition, boolean keepAir) {
        super(StructureManagerImpl.RANDOM_NBT_STRUCTURE_PIECE, 0, manager, nbtLocation, nbtLocation.toString(), placeSettings, templatePosition);
        this.keepAir = keepAir;
    }

    public RandomNbtStructurePiece(StructurePieceSerializationContext context, CompoundTag compoundTag) {
        this(context, compoundTag, compoundTag.contains("A") && compoundTag.getBoolean("A"));
    }

    public RandomNbtStructurePiece(StructurePieceSerializationContext context, CompoundTag compoundTag, boolean keepAir) {
        super(StructureManagerImpl.RANDOM_NBT_STRUCTURE_PIECE, compoundTag, context.structureTemplateManager(), loc -> RandomNbtStructurePiece.fromNbt(compoundTag, keepAir));
        this.keepAir = keepAir;
    }

    private static StructurePlaceSettings fromNbt(CompoundTag compoundTag, boolean keepAir) {
        return RandomNbtStructurePiece.settings(Rotation.valueOf((String)compoundTag.getString("R")), Mirror.valueOf((String)compoundTag.getString("M")), new BlockPos(compoundTag.getInt("RX"), compoundTag.getInt("RY"), compoundTag.getInt("RZ")), keepAir);
    }

    public static StructurePlaceSettings settings(Rotation rotation, Mirror mirror, BlockPos halfSize, boolean keepAir) {
        return new StructurePlaceSettings().setRotation(rotation).setRotationPivot(halfSize).setMirror(mirror).addProcessor((StructureProcessor)(keepAir ? BlockIgnoreProcessor.STRUCTURE_BLOCK : BlockIgnoreProcessor.STRUCTURE_AND_AIR));
    }

    protected void addAdditionalSaveData(StructurePieceSerializationContext structurePieceSerializationContext, CompoundTag tag) {
        super.addAdditionalSaveData(structurePieceSerializationContext, tag);
        tag.putString("R", this.placeSettings.getRotation().name());
        tag.putString("M", this.placeSettings.getMirror().name());
        tag.putInt("RX", this.placeSettings.getRotationPivot().getX());
        tag.putInt("RY", this.placeSettings.getRotationPivot().getY());
        tag.putInt("RZ", this.placeSettings.getRotationPivot().getZ());
        if (this.keepAir) {
            tag.putBoolean("A", this.keepAir);
        }
    }

    protected void handleDataMarker(String string, BlockPos blockPos, ServerLevelAccessor serverLevelAccessor, RandomSource randomSource, BoundingBox boundingBox) {
    }

    public void postProcess(WorldGenLevel worldGenLevel, StructureManager structureManager, ChunkGenerator chunkGenerator, RandomSource randomSource, BoundingBox writableBounds, ChunkPos chunkPos, BlockPos blockPos) {
        super.postProcess(worldGenLevel, structureManager, chunkGenerator, randomSource, writableBounds, chunkPos, blockPos);
    }
}

