/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.structure.impl;

import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.structure.Structure;
import org.betterx.wover.structure.api.StructureKey;
import org.betterx.wover.structure.api.builders.BaseStructureBuilder;
import org.betterx.wover.structure.impl.StructureManagerImpl;
import org.betterx.wover.tag.api.TagManager;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class StructureKeyImpl<S extends Structure, T extends BaseStructureBuilder<S, T>, R extends StructureKey<S, T, R>>
implements StructureKey<S, T, R> {
    @NotNull
    public final ResourceKey<Structure> key;
    @Nullable
    private TagKey<Biome> biomeTag;
    @NotNull
    private GenerationStep.Decoration decoration;

    @Override
    public final ResourceKey<Structure> key() {
        return this.key;
    }

    @Override
    @Nullable
    public Holder<Structure> getHolder(@Nullable HolderGetter<Structure> getter) {
        return StructureManagerImpl.getHolder(getter, this.key);
    }

    @Override
    @Nullable
    public Holder<Structure> getHolder(@Nullable HolderLookup.Provider lookup) {
        return StructureManagerImpl.getHolder(lookup, this.key);
    }

    @Override
    @Nullable
    public Holder<Structure> getHolder(@NotNull BootstrapContext<?> context) {
        return this.getHolder((HolderGetter<Structure>)context.lookup(Registries.STRUCTURE));
    }

    @Override
    @Nullable
    public Holder<Structure> getHolder(@NotNull RegistryAccess access) {
        return this.getHolder((HolderGetter<Structure>)access.lookupOrThrow(Registries.STRUCTURE));
    }

    @Override
    public R biomeTag(@Nullable TagKey<Biome> biomeTag) {
        this.biomeTag = biomeTag;
        return (R)this;
    }

    @Override
    @NotNull
    public TagKey<Biome> biomeTag() {
        if (this.biomeTag == null) {
            this.biomeTag = TagManager.BIOMES.makeStructureTag(this.key);
        }
        return this.biomeTag;
    }

    @Override
    public // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull GenerationStep.Decoration step() {
        return this.decoration;
    }

    @Override
    public R step(GenerationStep.Decoration decoration) {
        this.decoration = decoration;
        return (R)this;
    }

    @ApiStatus.Internal
    protected StructureKeyImpl(@NotNull ResourceLocation structureId) {
        this.key = ResourceKey.create((ResourceKey)Registries.STRUCTURE, (ResourceLocation)structureId);
        this.decoration = GenerationStep.Decoration.SURFACE_STRUCTURES;
    }
}

