/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.structure.impl.builders;

import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.structure.Structure;
import org.betterx.wover.structure.api.StructureKey;
import org.betterx.wover.structure.api.builders.RandomNbtBuilder;
import org.betterx.wover.structure.api.structures.StructurePlacement;
import org.betterx.wover.structure.api.structures.nbt.RandomNbtStructure;
import org.betterx.wover.structure.api.structures.nbt.RandomNbtStructureElement;
import org.betterx.wover.structure.impl.builders.BaseStructureBuilderImpl;
import org.betterx.wover.util.RandomizedWeightedList;

public class RandomNbtBuilderImpl
extends BaseStructureBuilderImpl<RandomNbtStructure, RandomNbtBuilder, StructureKey.RandomNbt>
implements RandomNbtBuilder {
    private StructurePlacement placement = StructurePlacement.SURFACE;
    private final RandomizedWeightedList<RandomNbtStructureElement> elements = new RandomizedWeightedList();
    private boolean keepAir = false;

    public RandomNbtBuilderImpl(StructureKey.RandomNbt key, BootstrapContext<Structure> context) {
        super(key, context);
    }

    @Override
    public RandomNbtBuilder keepAir(boolean value) {
        this.keepAir = value;
        return this;
    }

    @Override
    public RandomNbtBuilder placement(StructurePlacement value) {
        this.placement = value;
        return this;
    }

    @Override
    public RandomNbtBuilder addElement(ResourceLocation elementId, int yOffset, double weight) {
        this.elements.add(new RandomNbtStructureElement(elementId, yOffset), weight);
        return this;
    }

    @Override
    protected Structure build() {
        return new RandomNbtStructure(this.buildSettings(), this.placement, this.keepAir, this.elements);
    }
}

