/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.structure.impl.pools;

import com.mojang.serialization.MapCodec;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElementType;
import net.neoforged.neoforge.registries.RegisterEvent;
import org.betterx.wover.entrypoint.LibWoverStructure;
import org.betterx.wover.legacy.api.LegacyHelper;
import org.betterx.wover.structure.impl.pools.SingleEndPoolElement;
import org.jetbrains.annotations.ApiStatus;

public class StructurePoolElementTypeManagerImpl {
    private static final Map<ResourceKey<StructurePoolElementType<?>>, StructurePoolElementType<?>> TYPES = new LinkedHashMap();
    public static final ResourceKey<StructurePoolElementType<?>> END_KEY = ResourceKey.create((ResourceKey)Registries.STRUCTURE_POOL_ELEMENT, (ResourceLocation)LibWoverStructure.C.id("single_end_pool_element"));
    public static StructurePoolElementType<SingleEndPoolElement> END;

    public static <P extends StructurePoolElement> StructurePoolElementType<P> createType(MapCodec<P> codec) {
        return () -> codec;
    }

    public static void register(RegisterEvent event) {
        event.register(Registries.STRUCTURE_POOL_ELEMENT, helper -> {
            END = StructurePoolElementTypeManagerImpl.createType(SingleEndPoolElement.CODEC);
            TYPES.put(END_KEY, END);
            TYPES.forEach((key, type) -> helper.register(key.location(), type));
            if (LegacyHelper.isLegacyEnabled()) {
                helper.register(LegacyHelper.BCLIB_CORE.convertNamespace(END_KEY.location()), StructurePoolElementTypeManagerImpl.createType(LegacyHelper.wrap(SingleEndPoolElement.CODEC)));
            }
        });
    }

    @ApiStatus.Internal
    public static void ensureStaticallyLoaded() {
    }

    public static <P extends StructurePoolElement> StructurePoolElementType<P> registerExternal(ResourceLocation location, MapCodec<P> codec) {
        ResourceKey key = ResourceKey.create((ResourceKey)Registries.STRUCTURE_POOL_ELEMENT, (ResourceLocation)location);
        StructurePoolElementType type = TYPES.computeIfAbsent(key, k -> StructurePoolElementTypeManagerImpl.createType(codec));
        return type;
    }
}

