/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.surface.impl;

import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.SurfaceRules;
import org.betterx.wover.surface.api.conditions.NoiseCondition;
import org.betterx.wover.util.PriorityLinkedList;

public interface BaseSurfaceRuleBuilder<T extends BaseSurfaceRuleBuilder<T>> {
    public static final int STEEP_SURFACE_PRIORITY = 2 * PriorityLinkedList.DEFAULT_PRIORITY + 900;
    public static final int TOP_SURFACE_PRIORITY = 2 * PriorityLinkedList.DEFAULT_PRIORITY + 800;
    public static final int CEILING_PRIORITY = 2 * PriorityLinkedList.DEFAULT_PRIORITY + 700;
    public static final int SUB_SURFACE_PRIORITY = 2 * PriorityLinkedList.DEFAULT_PRIORITY + 600;
    public static final int FLOOR_PRIORITY = 2 * PriorityLinkedList.DEFAULT_PRIORITY + 500;
    public static final int BELOW_FLOOR_PRIORITY = 2 * PriorityLinkedList.DEFAULT_PRIORITY + 400;
    public static final int ABOVE_CEILING_PRIORITY = 2 * PriorityLinkedList.DEFAULT_PRIORITY + 300;
    public static final int FILLER_PRIORITY = PriorityLinkedList.DEFAULT_PRIORITY - 100;

    public T surface(BlockState var1);

    default public T surface(Block block) {
        return this.surface(block.defaultBlockState());
    }

    public T subsurface(BlockState var1, int var2);

    default public T subsurface(Block block, int depth) {
        return this.subsurface(block.defaultBlockState(), depth);
    }

    public T filler(BlockState var1);

    public T floor(BlockState var1);

    public T belowFloor(BlockState var1, int var2, NoiseCondition var3);

    public T belowFloor(BlockState var1, int var2);

    public T ceil(BlockState var1);

    public T aboveCeil(BlockState var1, int var2);

    public T steep(BlockState var1, int var2);

    public T rule(SurfaceRules.RuleSource var1, int var2);

    public T rule(SurfaceRules.RuleSource var1);

    public T chancedFloor(BlockState var1, BlockState var2);

    public T chancedFloor(BlockState var1, BlockState var2, NoiseCondition var3);

    public T chancedFloor(BlockState var1, SurfaceRules.RuleSource var2, NoiseCondition var3);

    public T sortPriority(int var1);
}

