/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.surface.impl;

import net.minecraft.core.Holder;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.SurfaceRules;
import net.minecraft.world.level.levelgen.placement.CaveSurface;
import org.betterx.wover.surface.api.AssignedSurfaceRule;
import org.betterx.wover.surface.api.Conditions;
import org.betterx.wover.surface.api.SurfaceRuleBuilder;
import org.betterx.wover.surface.api.conditions.NoiseCondition;
import org.betterx.wover.surface.impl.BaseSurfaceRuleBuilder;
import org.betterx.wover.surface.impl.SurfaceRuleRegistryImpl;
import org.betterx.wover.util.PriorityLinkedList;
import org.jetbrains.annotations.NotNull;

public class SurfaceRuleBuilderImpl<T extends BaseSurfaceRuleBuilder<T>>
implements BaseSurfaceRuleBuilder<T> {
    private final PriorityLinkedList<SurfaceRules.RuleSource> rules;
    protected ResourceKey<Biome> biomeKey = null;
    protected int sortPriority = PriorityLinkedList.DEFAULT_PRIORITY;

    public SurfaceRuleBuilderImpl() {
        this.rules = new PriorityLinkedList();
    }

    public T biome(ResourceKey<Biome> biomeKey) {
        this.biomeKey = biomeKey;
        return (T)this;
    }

    public T biome(Holder<Biome> biomeHolder) {
        this.biomeKey = (ResourceKey)biomeHolder.unwrapKey().orElseThrow();
        return (T)this;
    }

    public ResourceKey<Biome> biomeKey() {
        return this.biomeKey;
    }

    @Override
    public T surface(BlockState state) {
        SurfaceRules.RuleSource rule = SurfaceRules.state((BlockState)state);
        rule = SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.ON_FLOOR, (SurfaceRules.RuleSource)rule);
        this.rules.add(rule, TOP_SURFACE_PRIORITY);
        return (T)this;
    }

    @Override
    public T subsurface(BlockState state, int depth) {
        SurfaceRules.RuleSource rule = SurfaceRules.state((BlockState)state);
        rule = SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.stoneDepthCheck((int)depth, (boolean)false, (CaveSurface)CaveSurface.FLOOR), (SurfaceRules.RuleSource)rule);
        this.rules.add(rule, SUB_SURFACE_PRIORITY);
        return (T)this;
    }

    @Override
    public T filler(BlockState state) {
        this.rules.add(SurfaceRules.state((BlockState)state), FILLER_PRIORITY);
        return (T)this;
    }

    @Override
    public T floor(BlockState state) {
        SurfaceRules.RuleSource rule = SurfaceRules.state((BlockState)state);
        rule = SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.ON_FLOOR, (SurfaceRules.RuleSource)rule);
        this.rules.add(rule, FLOOR_PRIORITY);
        return (T)this;
    }

    @Override
    public T belowFloor(BlockState state, int height, NoiseCondition noise) {
        SurfaceRules.RuleSource rule = SurfaceRules.state((BlockState)state);
        rule = SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.stoneDepthCheck((int)height, (boolean)false, (CaveSurface)CaveSurface.FLOOR), (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)noise, (SurfaceRules.RuleSource)rule));
        this.rules.add(rule, BELOW_FLOOR_PRIORITY);
        return (T)this;
    }

    @Override
    public T belowFloor(BlockState state, int height) {
        SurfaceRules.RuleSource rule = SurfaceRules.state((BlockState)state);
        rule = SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.stoneDepthCheck((int)height, (boolean)false, (CaveSurface)CaveSurface.FLOOR), (SurfaceRules.RuleSource)rule);
        this.rules.add(rule, BELOW_FLOOR_PRIORITY);
        return (T)this;
    }

    @Override
    public T ceil(BlockState state) {
        SurfaceRules.RuleSource rule = SurfaceRules.state((BlockState)state);
        rule = SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.ON_CEILING, (SurfaceRules.RuleSource)rule);
        this.rules.add(rule, CEILING_PRIORITY);
        return (T)this;
    }

    @Override
    public T aboveCeil(BlockState state, int height) {
        SurfaceRules.RuleSource rule = SurfaceRules.state((BlockState)state);
        rule = SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.stoneDepthCheck((int)height, (boolean)false, (CaveSurface)CaveSurface.CEILING), (SurfaceRules.RuleSource)rule);
        this.rules.add(rule, ABOVE_CEILING_PRIORITY);
        return (T)this;
    }

    @Override
    public T steep(BlockState state, int depth) {
        SurfaceRules.RuleSource rule = SurfaceRules.state((BlockState)state);
        rule = SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.stoneDepthCheck((int)depth, (boolean)false, (CaveSurface)CaveSurface.FLOOR), (SurfaceRules.RuleSource)rule);
        rule = SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.steep(), (SurfaceRules.RuleSource)rule);
        this.rules.add(rule, STEEP_SURFACE_PRIORITY);
        return (T)this;
    }

    @Override
    public T rule(SurfaceRules.RuleSource rule, int priority) {
        this.rules.add(rule, priority);
        return (T)this;
    }

    @Override
    public T rule(SurfaceRules.RuleSource rule) {
        this.rules.add(rule);
        return (T)this;
    }

    @Override
    public T chancedFloor(BlockState surfaceBlockA, BlockState surfaceBlockB) {
        return this.chancedFloor(surfaceBlockA, surfaceBlockB, Conditions.DOUBLE_BLOCK_SURFACE_NOISE);
    }

    @Override
    public T chancedFloor(BlockState surfaceBlockA, BlockState surfaceBlockB, NoiseCondition noise) {
        SurfaceRules.RuleSource rule = SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.ON_FLOOR, (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)noise, (SurfaceRules.RuleSource)SurfaceRules.state((BlockState)surfaceBlockA)), SurfaceRules.state((BlockState)surfaceBlockB)}));
        this.rules.add(rule, FLOOR_PRIORITY);
        return (T)this;
    }

    @Override
    public T chancedFloor(BlockState surfaceBlockA, SurfaceRules.RuleSource surfaceBlockB, NoiseCondition noise) {
        SurfaceRules.RuleSource rule = SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.ON_FLOOR, (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)noise, (SurfaceRules.RuleSource)SurfaceRules.state((BlockState)surfaceBlockA)), surfaceBlockB}));
        this.rules.add(rule, FLOOR_PRIORITY);
        return (T)this;
    }

    @Override
    public T sortPriority(int priority) {
        this.sortPriority = priority;
        return (T)this;
    }

    public SurfaceRules.RuleSource build() {
        SurfaceRules.RuleSource rule = this.getRuleSource();
        if (this.biomeKey != null) {
            rule = SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{this.biomeKey}), (SurfaceRules.RuleSource)rule);
        }
        return rule;
    }

    @NotNull
    protected SurfaceRules.RuleSource getRuleSource() {
        if (this.rules.size() == 1) {
            return this.rules.get(0);
        }
        SurfaceRules.RuleSource[] ruleArray = this.rules.toArray((T1[])new SurfaceRules.RuleSource[this.rules.size()]);
        SurfaceRules.RuleSource rule = SurfaceRules.sequence((SurfaceRules.RuleSource[])ruleArray);
        return rule;
    }

    public static class StandalonBuilder
    extends SurfaceRuleBuilderImpl<SurfaceRuleBuilder>
    implements SurfaceRuleBuilder {
        @Override
        public Holder<AssignedSurfaceRule> register(@NotNull BootstrapContext<AssignedSurfaceRule> ctx, @NotNull ResourceKey<AssignedSurfaceRule> key) {
            if (this.biomeKey == null) {
                throw new IllegalStateException("Biome key is not set for surface rule '" + String.valueOf(key.location()) + "'");
            }
            return SurfaceRuleRegistryImpl.register(ctx, key, (ResourceKey<Biome>)this.biomeKey, this.getRuleSource(), this.sortPriority);
        }
    }
}

