/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.ui.impl.client;

import com.mojang.blaze3d.systems.RenderSystem;
import de.ambertation.wunderlib.ui.ColorHelper;
import de.ambertation.wunderlib.ui.layout.components.HorizontalStack;
import de.ambertation.wunderlib.ui.layout.components.LayoutComponent;
import de.ambertation.wunderlib.ui.layout.components.VerticalStack;
import de.ambertation.wunderlib.ui.layout.values.Size;
import de.ambertation.wunderlib.ui.layout.values.Value;
import java.net.URL;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.fml.ModContainer;
import org.betterx.wover.config.api.client.ClientConfigs;
import org.betterx.wover.core.api.ModCore;
import org.betterx.wover.entrypoint.LibWoverUi;
import org.betterx.wover.ui.api.VersionChecker;
import org.betterx.wover.ui.impl.client.WoverLayoutScreen;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class UpdatesScreen
extends WoverLayoutScreen {
    static final ResourceLocation UPDATE_LOGO_LOCATION = LibWoverUi.C.mk("icon_updater.png");

    public UpdatesScreen(@NotNull Runnable onClose) {
        super(onClose, (Component)Component.translatable((String)"wover.updates.title"), 10, 10, 10);
    }

    public UpdatesScreen(Screen parent) {
        super(UpdatesScreen.setScreenOnClose((Screen)parent), (Component)Component.translatable((String)"wover.updates.title"), 10, 10, 10);
    }

    public static void showUpdateUI() {
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(() -> Minecraft.getInstance().setScreen((Screen)new UpdatesScreen(Minecraft.getInstance().screen)));
        } else {
            Minecraft.getInstance().setScreen((Screen)new UpdatesScreen(Minecraft.getInstance().screen));
        }
    }

    public ResourceLocation getUpdaterIcon(ModCore core) {
        Object icon;
        if (core.namespace.equals(LibWoverUi.C.namespace)) {
            return UPDATE_LOGO_LOCATION;
        }
        ModContainer nfo = core.modContainer;
        Map<String, Object> props = UpdatesScreen.getWoverProperties(nfo);
        if (props != null && (icon = props.get("updater_icon")) instanceof String) {
            String iconName = (String)icon;
            return core.mk(iconName);
        }
        return null;
    }

    private static Map<String, Object> getWoverProperties(ModContainer container) {
        if (container == null) {
            return null;
        }
        Object props = container.getModInfo().getModProperties().get("wover");
        if (props instanceof Map) {
            Map map = (Map)props;
            return map;
        }
        return null;
    }

    protected LayoutComponent<?, ?> initContent() {
        VerticalStack rows = (VerticalStack)new VerticalStack(UpdatesScreen.relative((double)1.0), UpdatesScreen.fit()).centerHorizontal();
        rows.addMultilineText(UpdatesScreen.fill(), UpdatesScreen.fit(), (Component)Component.translatable((String)"wover.updates.description")).centerHorizontal();
        rows.addSpacer(8);
        VersionChecker.forEachUpdate((mod, cur, updated) -> {
            Object patt0$temp;
            ModCore core = ModCore.create(mod);
            ModContainer nfo = core.modContainer;
            ResourceLocation icon = this.getUpdaterIcon(core);
            HorizontalStack row = (HorizontalStack)rows.addRow(UpdatesScreen.fixed((int)320), UpdatesScreen.fit()).centerHorizontal();
            if (icon != null) {
                row.addImage(Value.fit(), Value.fit(), icon, Size.of((int)32));
                row.addSpacer(4);
            } else {
                row.addSpacer(36);
            }
            if (nfo != null) {
                row.addText(UpdatesScreen.fit(), UpdatesScreen.fit(), (Component)Component.literal((String)nfo.getModInfo().getDisplayName())).setColor(ColorHelper.WHITE);
            } else {
                row.addText(UpdatesScreen.fit(), UpdatesScreen.fit(), (Component)Component.literal((String)mod)).setColor(ColorHelper.WHITE);
            }
            row.addSpacer(4);
            row.addText(UpdatesScreen.fit(), UpdatesScreen.fit(), (Component)Component.literal((String)cur));
            row.addText(UpdatesScreen.fit(), UpdatesScreen.fit(), (Component)Component.literal((String)" -> "));
            row.addText(UpdatesScreen.fit(), UpdatesScreen.fit(), (Component)Component.literal((String)updated)).setColor(ColorHelper.GREEN);
            row.addFiller();
            boolean createdDownloadLink = false;
            Map<String, Object> woverProps = UpdatesScreen.getWoverProperties(nfo);
            if (woverProps != null && (patt0$temp = woverProps.get("downloads")) instanceof Map) {
                Map downloadLinks = (Map)patt0$temp;
                String link = null;
                MutableComponent name = null;
                Object modrinth = downloadLinks.get("modrinth");
                Object curseforge = downloadLinks.get("curseforge");
                if (((Boolean)ClientConfigs.CLIENT.prefereModrinth.get()).booleanValue() && modrinth instanceof String) {
                    String modrinthLink;
                    link = modrinthLink = (String)modrinth;
                    name = Component.translatable((String)"wover.updates.modrinth_link");
                } else if (curseforge instanceof String) {
                    String curseforgeLink;
                    link = curseforgeLink = (String)curseforge;
                    name = Component.translatable((String)"wover.updates.curseforge_link");
                }
                if (link != null) {
                    createdDownloadLink = true;
                    String finalLink = link;
                    row.addButton(UpdatesScreen.fit(), UpdatesScreen.fit(), (Component)name).onPress(bt -> this.openLink(finalLink)).centerVertical();
                }
            }
            if (!createdDownloadLink && nfo != null && nfo.getModInfo().getModURL().isPresent()) {
                row.addButton(UpdatesScreen.fit(), UpdatesScreen.fit(), (Component)Component.translatable((String)"wover.updates.download_link")).onPress(bt -> this.openLink(((URL)nfo.getModInfo().getModURL().get()).toString())).centerVertical();
            }
        });
        VerticalStack layout = (VerticalStack)new VerticalStack(UpdatesScreen.relative((double)1.0), UpdatesScreen.fill()).centerHorizontal();
        layout.addScrollable((LayoutComponent)rows);
        layout.addSpacer(8);
        HorizontalStack footer = layout.addRow(UpdatesScreen.fill(), UpdatesScreen.fit());
        footer.addFiller();
        footer.addCheckbox(UpdatesScreen.fit(), UpdatesScreen.fit(), (Component)Component.translatable((String)"wover.updates.disable_check"), (Boolean)ClientConfigs.CLIENT.checkForNewVersions.get() == false).onChange((cb, state) -> {
            ClientConfigs.CLIENT.checkForNewVersions.set((Object)(!state ? 1 : 0));
            ClientConfigs.CLIENT.save();
        });
        footer.addSpacer(4);
        footer.addButton(UpdatesScreen.fit(), UpdatesScreen.fit(), CommonComponents.GUI_DONE).onPress(bt -> this.onClose());
        return layout;
    }

    public void renderBackground(GuiGraphics guiGraphics, int i, int j, float f) {
        guiGraphics.fill(0, 0, this.width, this.height, -1120652220);
    }
}

