/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.util;

import java.util.HashSet;
import net.minecraft.resources.ResourceLocation;
import org.betterx.wover.core.api.ModCore;

public class ResourceLocationSet
extends HashSet<ResourceLocation> {
    @Override
    public boolean contains(Object o) {
        if (o instanceof ResourceLocation) {
            ResourceLocation location = (ResourceLocation)o;
            return this.containsResource(location);
        }
        return super.contains(o);
    }

    private boolean containsResource(ResourceLocation o) {
        if (!super.contains(o)) {
            return super.stream().anyMatch(location -> {
                if (location.getPath().equals("__..-all-..__")) {
                    return location.getNamespace().equals(o.getNamespace());
                }
                return false;
            });
        }
        return true;
    }

    public static class WildcardResourceLocation {
        static final String CATCH_ALL_PATH = "__..-all-..__";

        private WildcardResourceLocation() {
        }

        private static String[] parse(String string, String c) {
            String[] parts = string.split(c, 2);
            if (parts.length == 2) {
                return parts;
            }
            return new String[]{"minecraft", string};
        }

        public static ResourceLocation forAllFrom(ModCore mod) {
            return ResourceLocation.fromNamespaceAndPath((String)mod.namespace, (String)CATCH_ALL_PATH);
        }

        public static ResourceLocation parse(String string) {
            String[] decomposed = WildcardResourceLocation.parse(string, ":");
            if (decomposed[1].equals("*")) {
                return ResourceLocation.fromNamespaceAndPath((String)decomposed[0], (String)CATCH_ALL_PATH);
            }
            return ResourceLocation.fromNamespaceAndPath((String)decomposed[0], (String)decomposed[1]);
        }
    }
}

