/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether;

import java.util.HashSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import org.betterx.betternether.blocks.BlockFarmland;
import org.betterx.betternether.blocks.BlockTerrain;
import org.betterx.wover.tag.api.predefined.CommonBlockTags;

public class BlocksHelper {
    public static final int FLAG_UPDATE_BLOCK = 1;
    public static final int FLAG_SEND_CLIENT_CHANGES = 2;
    public static final int FLAG_NO_RERENDER = 4;
    public static final int FORSE_RERENDER = 8;
    public static final int FLAG_IGNORE_OBSERVERS = 16;
    public static final int SET_SILENT = 18;
    public static final int SET_UPDATE = 3;
    public static final Direction[] HORIZONTAL = new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST};
    private static final Vec3i[] OFFSETS = new Vec3i[]{new Vec3i(-1, -1, -1), new Vec3i(-1, -1, 0), new Vec3i(-1, -1, 1), new Vec3i(-1, 0, -1), new Vec3i(-1, 0, 0), new Vec3i(-1, 0, 1), new Vec3i(-1, 1, -1), new Vec3i(-1, 1, 0), new Vec3i(-1, 1, 1), new Vec3i(0, -1, -1), new Vec3i(0, -1, 0), new Vec3i(0, -1, 1), new Vec3i(0, 0, -1), new Vec3i(0, 0, 0), new Vec3i(0, 0, 1), new Vec3i(0, 1, -1), new Vec3i(0, 1, 0), new Vec3i(0, 1, 1), new Vec3i(1, -1, -1), new Vec3i(1, -1, 0), new Vec3i(1, -1, 1), new Vec3i(1, 0, -1), new Vec3i(1, 0, 0), new Vec3i(1, 0, 1), new Vec3i(1, 1, -1), new Vec3i(1, 1, 0), new Vec3i(1, 1, 1)};

    public static BoundingBox chunkBounds(LevelAccessor world, BlockPos pos) {
        int minBuildHeight = world.getMinBuildHeight() + 1;
        int maxBuildHeight = world.getMaxBuildHeight() - 1;
        return BlocksHelper.chunkBounds(world, pos, minBuildHeight, maxBuildHeight);
    }

    public static BoundingBox chunkBounds(LevelAccessor world, BlockPos pos, int minY, int maxY) {
        int chunkStartX = pos.getX() >> 4 << 4;
        int chunkStartZ = pos.getZ() >> 4 << 4;
        return new BoundingBox(chunkStartX, minY, chunkStartZ, chunkStartX + 31, maxY, chunkStartZ + 31);
    }

    public static BoundingBox decorationBounds(LevelAccessor world, BlockPos pos) {
        int minBuildHeight = world.getMinBuildHeight() + 1;
        int maxBuildHeight = world.getMaxBuildHeight() - 1;
        return BlocksHelper.decorationBounds(world, pos, minBuildHeight, maxBuildHeight);
    }

    public static BoundingBox decorationBounds(LevelAccessor world, BlockPos pos, int minY, int maxY) {
        int chunkStartX = pos.getX() >> 4 << 4;
        int chunkStartZ = pos.getZ() >> 4 << 4;
        return new BoundingBox(chunkStartX - 16, minY, chunkStartZ - 16, chunkStartX + 31, maxY, chunkStartZ + 31);
    }

    public static boolean isNetherrack(BlockState state) {
        return state.is(CommonBlockTags.NETHERRACK);
    }

    public static boolean isSoulSand(BlockState state) {
        return state.is(CommonBlockTags.SOUL_GROUND);
    }

    public static boolean isNetherGround(BlockState state) {
        boolean terrain = state.is(CommonBlockTags.NETHER_TERRAIN);
        boolean netherrack = state.is(CommonBlockTags.NETHERRACK);
        boolean stones = state.is(CommonBlockTags.NETHER_STONES);
        boolean soul = BlocksHelper.isSoulSand(state);
        boolean mycelium = BlocksHelper.isNetherMycelium(state);
        boolean nylium = BlocksHelper.isNylium(state);
        boolean classMatch = state.getBlock() instanceof BlockTerrain;
        boolean result = terrain || netherrack || stones || soul || mycelium || nylium || classMatch;
        return result;
    }

    public static boolean isNetherGroundMagma(BlockState state) {
        return BlocksHelper.isNetherGround(state) || state.is(Blocks.MAGMA_BLOCK);
    }

    public static boolean isNetherMycelium(BlockState state) {
        return state.is(CommonBlockTags.NETHER_MYCELIUM);
    }

    public static void setWithUpdate(LevelAccessor world, BlockPos pos, BlockState state, BoundingBox bounds) {
        if (bounds.isInside((Vec3i)pos)) {
            world.setBlock(pos, state, 3);
        }
    }

    public static void setWithUpdate(LevelAccessor world, BlockPos pos, BlockState state) {
        world.setBlock(pos, state, 3);
    }

    public static void setWithoutUpdate(LevelAccessor world, BlockPos pos, BlockState state, BoundingBox bounds) {
        if (bounds.isInside((Vec3i)pos)) {
            world.setBlock(pos, state, 18);
        }
    }

    public static void setWithoutUpdate(LevelAccessor world, BlockPos pos, BlockState state) {
        world.setBlock(pos, state, 18);
    }

    public static int upRay(LevelAccessor world, BlockPos pos, int maxDist) {
        int length = 0;
        for (int j = 1; j < maxDist && world.isEmptyBlock(pos.above(j)); ++j) {
            ++length;
        }
        return length;
    }

    public static int downRay(LevelAccessor world, BlockPos pos, int maxDist) {
        int length = 0;
        for (int j = 1; j < maxDist && world.isEmptyBlock(pos.below(j)); ++j) {
            ++length;
        }
        return length;
    }

    public static BlockState rotateHorizontal(BlockState state, Rotation rotation, Property<Direction> facing) {
        return (BlockState)state.setValue(facing, (Comparable)rotation.rotate((Direction)state.getValue(facing)));
    }

    public static BlockState mirrorHorizontal(BlockState state, Mirror mirror, Property<Direction> facing) {
        return state.rotate(mirror.getRotation((Direction)state.getValue(facing)));
    }

    public static int getLengthDown(ServerLevel world, BlockPos pos, Block block) {
        int count = 1;
        while (world.getBlockState(pos.below(count)).getBlock() == block) {
            ++count;
        }
        return count;
    }

    public static boolean isFertile(BlockState state) {
        return state.getBlock() instanceof BlockFarmland;
    }

    public static void cover(LevelAccessor world, BlockPos center, Block ground, BlockState cover, int radius, RandomSource random) {
        HashSet<Object> points = new HashSet<Object>();
        HashSet<BlockPos> points2 = new HashSet<BlockPos>();
        if (world.getBlockState(center).getBlock() == ground) {
            points.add(center);
            points2.add(center);
            for (int i = 0; i < radius; ++i) {
                for (BlockPos blockPos : points) {
                    for (Vec3i offset : OFFSETS) {
                        if (!random.nextBoolean()) continue;
                        BlockPos pos2 = blockPos.offset(offset);
                        if (!random.nextBoolean() || world.getBlockState(pos2).getBlock() != ground || points.contains(pos2)) continue;
                        points2.add(pos2);
                    }
                }
                points.addAll(points2);
                points2.clear();
            }
            for (BlockPos blockPos : points) {
                BlocksHelper.setWithoutUpdate(world, blockPos, cover);
            }
        }
    }

    public static boolean isNylium(BlockState state) {
        return state.is(BlockTags.NYLIUM);
    }

    public static boolean createLogIfFree(LevelAccessor world, BlockPos pos, BlockState anchorBlock, Direction[] directions, BlockPos.MutableBlockPos mutableBlockPos) {
        boolean hasNeighbor = false;
        for (Direction dir : directions) {
            mutableBlockPos.setWithOffset((Vec3i)pos, dir);
            BlockState currentState = world.getBlockState((BlockPos)mutableBlockPos);
            if (!currentState.hasProperty((Property)BlockStateProperties.DISTANCE) && !currentState.is(BlockTags.LOGS)) continue;
            hasNeighbor = true;
            break;
        }
        if (!hasNeighbor) {
            BlocksHelper.setWithoutUpdate(world, pos.above(), anchorBlock);
            return true;
        }
        return false;
    }
}

