/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.blockentities;

import java.util.Arrays;
import java.util.Iterator;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.Containers;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.BrewingStandMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BrewingStandBlock;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.betterx.betternether.registry.BlockEntitiesRegistry;
import org.betterx.betternether.registry.BrewingRegistry;

public class BNBrewingStandBlockEntity
extends BaseContainerBlockEntity
implements WorldlyContainer {
    private static final int[] TOP_SLOTS = new int[]{3};
    private static final int[] BOTTOM_SLOTS = new int[]{0, 1, 2, 3};
    private static final int[] SIDE_SLOTS = new int[]{0, 1, 2, 4};
    private NonNullList<ItemStack> inventory = NonNullList.withSize((int)5, (Object)ItemStack.EMPTY);
    private int brewTime;
    private boolean[] slotsEmptyLastTick;
    private Item itemBrewing;
    private int fuel;
    protected final ContainerData propertyDelegate = new ContainerData(){

        public int get(int index) {
            switch (index) {
                case 0: {
                    return BNBrewingStandBlockEntity.this.brewTime;
                }
                case 1: {
                    return BNBrewingStandBlockEntity.this.fuel;
                }
            }
            return 0;
        }

        public void set(int index, int value) {
            switch (index) {
                case 0: {
                    BNBrewingStandBlockEntity.this.brewTime = value;
                    break;
                }
                case 1: {
                    BNBrewingStandBlockEntity.this.fuel = value;
                }
            }
        }

        public int getCount() {
            return 2;
        }
    };

    public BNBrewingStandBlockEntity(BlockPos blockPos, BlockState blockState) {
        super(BlockEntitiesRegistry.NETHER_BREWING_STAND, blockPos, blockState);
    }

    protected NonNullList<ItemStack> getItems() {
        return this.inventory;
    }

    protected void setItems(NonNullList<ItemStack> nonNullList) {
        this.inventory = nonNullList;
    }

    protected Component getDefaultName() {
        return Component.translatable((String)"container.brewing", (Object[])new Object[0]);
    }

    public int getContainerSize() {
        return this.inventory.size();
    }

    public boolean isEmpty() {
        ItemStack itemStack;
        Iterator var1 = this.inventory.iterator();
        do {
            if (var1.hasNext()) continue;
            return true;
        } while ((itemStack = (ItemStack)var1.next()).isEmpty());
        return false;
    }

    public static void tick(Level world, BlockPos pos, BlockState state, BNBrewingStandBlockEntity blockEntity) {
        boolean[] bls;
        ItemStack itemStack = (ItemStack)blockEntity.inventory.get(4);
        if (blockEntity.fuel <= 0 && itemStack.getItem() == Items.BLAZE_POWDER) {
            blockEntity.fuel = 20;
            itemStack.shrink(1);
            BNBrewingStandBlockEntity.setChanged((Level)world, (BlockPos)pos, (BlockState)state);
        }
        boolean bl = blockEntity.canCraft(world != null ? world.potionBrewing() : PotionBrewing.EMPTY);
        boolean bl2 = blockEntity.brewTime > 0;
        ItemStack itemStack2 = (ItemStack)blockEntity.inventory.get(3);
        if (bl2) {
            boolean bl3;
            --blockEntity.brewTime;
            boolean bl4 = bl3 = blockEntity.brewTime == 0;
            if (bl3 && bl) {
                blockEntity.craft();
                BNBrewingStandBlockEntity.setChanged((Level)world, (BlockPos)pos, (BlockState)state);
            } else if (!bl) {
                blockEntity.brewTime = 0;
                BNBrewingStandBlockEntity.setChanged((Level)world, (BlockPos)pos, (BlockState)state);
            } else if (blockEntity.itemBrewing != itemStack2.getItem()) {
                blockEntity.brewTime = 0;
                BNBrewingStandBlockEntity.setChanged((Level)world, (BlockPos)pos, (BlockState)state);
            }
        } else if (bl && blockEntity.fuel > 0) {
            --blockEntity.fuel;
            blockEntity.brewTime = 400;
            blockEntity.itemBrewing = itemStack2.getItem();
            BNBrewingStandBlockEntity.setChanged((Level)world, (BlockPos)pos, (BlockState)state);
        }
        if (!blockEntity.level.isClientSide && !Arrays.equals(bls = blockEntity.getSlotsEmpty(), blockEntity.slotsEmptyLastTick)) {
            blockEntity.slotsEmptyLastTick = bls;
            BlockState blockState = state;
            if (!(blockState.getBlock() instanceof BrewingStandBlock)) {
                return;
            }
            for (int i = 0; i < BrewingStandBlock.HAS_BOTTLE.length; ++i) {
                blockState = (BlockState)blockState.setValue((Property)BrewingStandBlock.HAS_BOTTLE[i], (Comparable)Boolean.valueOf(bls[i]));
            }
            blockEntity.level.setBlock(pos, blockState, 2);
        }
    }

    public boolean[] getSlotsEmpty() {
        boolean[] bls = new boolean[3];
        for (int i = 0; i < 3; ++i) {
            if (((ItemStack)this.inventory.get(i)).isEmpty()) continue;
            bls[i] = true;
        }
        return bls;
    }

    private boolean canCraft(PotionBrewing potionBrewing) {
        ItemStack source = (ItemStack)this.inventory.get(3);
        if (source.isEmpty()) {
            return false;
        }
        if (!potionBrewing.isIngredient(source)) {
            return false;
        }
        for (int i = 0; i < 3; ++i) {
            ItemStack bottle = (ItemStack)this.inventory.get(i);
            if (bottle.isEmpty()) continue;
            if (potionBrewing.hasMix(bottle, source)) {
                return true;
            }
            if (BrewingRegistry.getResult(source, bottle) == null) continue;
            return true;
        }
        return false;
    }

    private void craft() {
        this.craft(this.level, this.worldPosition, this.getBlockState());
    }

    private void craft(Level world, BlockPos blockPos, BlockState state) {
        ItemStack source = (ItemStack)this.inventory.get(3);
        PotionBrewing potionBrewing = this.level != null ? this.level.potionBrewing() : PotionBrewing.EMPTY;
        for (int i = 0; i < 3; ++i) {
            ItemStack bottle = (ItemStack)this.inventory.get(i);
            if (bottle.isEmpty()) continue;
            ItemStack result = BrewingRegistry.getResult(source, bottle);
            if (result != null) {
                this.inventory.set(i, (Object)result.copy());
                continue;
            }
            this.inventory.set(i, (Object)potionBrewing.mix(source, (ItemStack)this.inventory.get(i)));
        }
        source.shrink(1);
        if (source.getItem().hasCraftingRemainingItem()) {
            ItemStack itemStack2 = new ItemStack((ItemLike)source.getItem().getCraftingRemainingItem());
            if (source.isEmpty()) {
                source = itemStack2;
            } else if (!world.isClientSide) {
                Containers.dropItemStack((Level)world, (double)blockPos.getX(), (double)blockPos.getY(), (double)blockPos.getZ(), (ItemStack)itemStack2);
            }
        }
        this.inventory.set(3, (Object)source);
        this.level.levelEvent(1035, blockPos, 0);
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.inventory = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
        ContainerHelper.loadAllItems((CompoundTag)tag, this.inventory, (HolderLookup.Provider)provider);
        this.brewTime = tag.getShort("BrewTime");
        this.fuel = tag.getByte("Fuel");
    }

    public void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.putShort("BrewTime", (short)this.brewTime);
        ContainerHelper.saveAllItems((CompoundTag)tag, this.inventory, (HolderLookup.Provider)provider);
        tag.putByte("Fuel", (byte)this.fuel);
    }

    public ItemStack getItem(int slot) {
        return slot >= 0 && slot < this.inventory.size() ? (ItemStack)this.inventory.get(slot) : ItemStack.EMPTY;
    }

    public ItemStack removeItem(int slot, int amount) {
        return ContainerHelper.removeItem(this.inventory, (int)slot, (int)amount);
    }

    public ItemStack removeItemNoUpdate(int slot) {
        return ContainerHelper.takeItem(this.inventory, (int)slot);
    }

    public void setItem(int slot, ItemStack stack) {
        if (slot >= 0 && slot < this.inventory.size()) {
            this.inventory.set(slot, (Object)stack);
        }
    }

    public boolean stillValid(Player player) {
        if (this.level.getBlockEntity(this.worldPosition) != this) {
            return false;
        }
        return player.distanceToSqr((double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() + 0.5, (double)this.worldPosition.getZ() + 0.5) <= 64.0;
    }

    public boolean canPlaceItem(int slot, ItemStack stack) {
        if (slot == 3) {
            PotionBrewing potionBrewing = this.level != null ? this.level.potionBrewing() : PotionBrewing.EMPTY;
            return potionBrewing.isIngredient(stack);
        }
        Item item = stack.getItem();
        if (slot == 4) {
            if (item == Items.BLAZE_POWDER) {
                return true;
            }
            ResourceLocation id = BuiltInRegistries.ITEM.getKey((Object)item);
            return id.getNamespace().equals("biomemakeover") && id.getPath().equals("soul_embers");
        }
        return (item == Items.POTION || item == Items.SPLASH_POTION || item == Items.LINGERING_POTION || item == Items.GLASS_BOTTLE) && this.getItem(slot).isEmpty();
    }

    public int[] getSlotsForFace(Direction side) {
        if (side == Direction.UP) {
            return TOP_SLOTS;
        }
        return side == Direction.DOWN ? BOTTOM_SLOTS : SIDE_SLOTS;
    }

    public boolean canPlaceItemThroughFace(int slot, ItemStack stack, @Nullable Direction dir) {
        return this.canPlaceItem(slot, stack);
    }

    public boolean canTakeItemThroughFace(int slot, ItemStack stack, Direction dir) {
        if (slot == 3) {
            return stack.getItem() == Items.GLASS_BOTTLE;
        }
        return true;
    }

    public void clearContent() {
        this.inventory.clear();
    }

    protected AbstractContainerMenu createMenu(int syncId, Inventory playerInventory) {
        return new BrewingStandMenu(syncId, playerInventory, (Container)this, this.propertyDelegate);
    }
}

