/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.blocks;

import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.betterx.bclib.util.LootUtil;
import org.betterx.betternether.BlocksHelper;
import org.betterx.betternether.blocks.BNRenderLayer;
import org.betterx.betternether.blocks.BlockBaseNotFull;
import org.betterx.betternether.blocks.materials.Materials;

class BaseBlockMold
extends BlockBaseNotFull {
    public BaseBlockMold(MapColor color) {
        this(color, p -> p);
    }

    public BaseBlockMold(MapColor color, Function<BlockBehaviour.Properties, BlockBehaviour.Properties> adaptProperties) {
        super(adaptProperties.apply(Materials.makeNetherGrass(color).sound(SoundType.CROP).randomTicks()));
        this.setRenderLayer(BNRenderLayer.CUTOUT);
        this.setDropItself(false);
    }

    public BaseBlockMold(BlockBehaviour.Properties settings) {
        super(settings);
        this.setRenderLayer(BNRenderLayer.CUTOUT);
        this.setDropItself(false);
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getShadeBrightness(BlockState state, BlockGetter view, BlockPos pos) {
        return 1.0f;
    }

    public BlockState updateShape(BlockState state, Direction facing, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (!this.canSurvive(state, (LevelReader)world, pos)) {
            return Blocks.AIR.defaultBlockState();
        }
        return state;
    }

    public void randomTick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        super.randomTick(state, world, pos, random);
        if (random.nextInt(16) == 0) {
            int c = 0;
            c = world.getBlockState(pos.north()).getBlock() == this ? c++ : c;
            c = world.getBlockState(pos.south()).getBlock() == this ? c++ : c;
            c = world.getBlockState(pos.east()).getBlock() == this ? c++ : c;
            int n = c = world.getBlockState(pos.west()).getBlock() == this ? c++ : c;
            if (c < 2) {
                BlockPos npos = new BlockPos((Vec3i)pos);
                switch (random.nextInt(4)) {
                    case 0: {
                        npos = npos.offset(-1, 0, 0);
                        break;
                    }
                    case 1: {
                        npos = npos.offset(1, 0, 0);
                        break;
                    }
                    case 2: {
                        npos = npos.offset(0, 0, -1);
                        break;
                    }
                    default: {
                        npos = npos.offset(0, 0, 1);
                    }
                }
                if (world.isEmptyBlock(npos) && this.canSurvive(state, (LevelReader)world, npos)) {
                    BlocksHelper.setWithoutUpdate((LevelAccessor)world, npos, this.defaultBlockState());
                }
            }
        }
    }

    @Override
    public List<ItemStack> getDrops(BlockState state, LootParams.Builder builder) {
        ItemStack tool = (ItemStack)builder.getParameter(LootContextParams.TOOL);
        if (LootUtil.isCorrectTool((ItemLike)this, (BlockState)state, (ItemStack)tool)) {
            return Collections.singletonList(new ItemStack((ItemLike)this.asItem()));
        }
        return super.getDrops(state, builder);
    }
}

