/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.blocks;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.betterx.bclib.behaviours.BehaviourHelper;
import org.betterx.bclib.behaviours.interfaces.BehaviourMetal;
import org.betterx.bclib.behaviours.interfaces.BehaviourStone;
import org.betterx.bclib.behaviours.interfaces.BehaviourWood;
import org.betterx.betternether.BlocksHelper;
import org.betterx.betternether.blocks.BlockBaseNotFull;
import org.betterx.betternether.blocks.BlockPottedPlant;

public abstract class BlockBNPot
extends BlockBaseNotFull {
    private static final VoxelShape SHAPE = BlockBNPot.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)8.0, (double)13.0);

    protected BlockBNPot(Block material) {
        super(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)material).noOcclusion());
    }

    public boolean useShapeForLightOcclusion(BlockState state) {
        return true;
    }

    public VoxelShape getShape(BlockState state, BlockGetter view, BlockPos pos, CollisionContext ePos) {
        return SHAPE;
    }

    public ItemInteractionResult useItemOn(ItemStack itemStack, BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockState plant;
        BlockPos plantPos = pos.above();
        if (hit.getDirection() == Direction.UP && world.isEmptyBlock(plantPos) && (plant = BlockPottedPlant.getPlant(player.getMainHandItem().getItem())) != null) {
            if (!world.isClientSide()) {
                BlocksHelper.setWithUpdate((LevelAccessor)world, plantPos, plant);
            }
            world.playLocalSound((double)pos.getX() + 0.5, (double)pos.getY() + 1.5, (double)pos.getZ() + 0.5, SoundEvents.CROP_PLANTED, SoundSource.BLOCKS, 0.8f, 1.0f, true);
            if (!player.isCreative()) {
                player.getMainHandItem().shrink(1);
            }
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.FAIL;
    }

    public static BlockBNPot from(Block source) {
        return (BlockBNPot)BehaviourHelper.from((Block)source, Wood::new, Stone::new, Metal::new);
    }

    public static class Metal
    extends BlockBNPot
    implements BehaviourMetal {
        public Metal(Block material) {
            super(material);
        }
    }

    public static class Stone
    extends BlockBNPot
    implements BehaviourStone {
        public Stone(Block material) {
            super(material);
        }
    }

    public static class Wood
    extends BlockBNPot
    implements BehaviourWood {
        public Wood(Block material) {
            super(material);
        }
    }
}

