/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.blocks;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.betterx.bclib.interfaces.tools.AddMineableAxe;
import org.betterx.betternether.blocks.BNBlockProperties;
import org.betterx.betternether.blocks.BlockBaseNotFull;
import org.betterx.betternether.blocks.materials.Materials;
import org.betterx.betternether.registry.NetherBlocks;

public class BlockBrownLargeMushroom
extends BlockBaseNotFull
implements AddMineableAxe {
    private static final VoxelShape TOP_CENTER_SHAPE = BlockBrownLargeMushroom.box((double)0.0, (double)0.1, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape TOP_EDGE_SHAPE = BlockBrownLargeMushroom.box((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape MIDDLE_SHAPE = BlockBrownLargeMushroom.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    public static final EnumProperty<BNBlockProperties.BrownMushroomShape> SHAPE = BNBlockProperties.BROWN_MUSHROOM_SHAPE;
    private static final BNBlockProperties.BrownMushroomShape[] ROT_SIDE = new BNBlockProperties.BrownMushroomShape[]{BNBlockProperties.BrownMushroomShape.SIDE_N, BNBlockProperties.BrownMushroomShape.SIDE_E, BNBlockProperties.BrownMushroomShape.SIDE_S, BNBlockProperties.BrownMushroomShape.SIDE_W};
    private static final BNBlockProperties.BrownMushroomShape[] ROT_CORNER = new BNBlockProperties.BrownMushroomShape[]{BNBlockProperties.BrownMushroomShape.CORNER_N, BNBlockProperties.BrownMushroomShape.CORNER_E, BNBlockProperties.BrownMushroomShape.CORNER_S, BNBlockProperties.BrownMushroomShape.CORNER_W};

    public BlockBrownLargeMushroom() {
        super(Materials.makeNetherWood(MapColor.COLOR_BROWN).strength(1.0f).noOcclusion());
        this.setDropItself(false);
    }

    @OnlyIn(value=Dist.CLIENT)
    public ItemStack getCloneItemStack(LevelReader world, BlockPos pos, BlockState state) {
        BNBlockProperties.BrownMushroomShape shape = (BNBlockProperties.BrownMushroomShape)((Object)state.getValue(SHAPE));
        return shape == BNBlockProperties.BrownMushroomShape.BOTTOM || shape == BNBlockProperties.BrownMushroomShape.MIDDLE ? new ItemStack((ItemLike)NetherBlocks.MAT_NETHER_MUSHROOM.getStem()) : new ItemStack((ItemLike)Items.BROWN_MUSHROOM);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> stateManager) {
        stateManager.add(new Property[]{SHAPE});
    }

    public VoxelShape getShape(BlockState state, BlockGetter view, BlockPos pos, CollisionContext ePos) {
        BNBlockProperties.BrownMushroomShape shape = (BNBlockProperties.BrownMushroomShape)((Object)state.getValue(SHAPE));
        if (shape == BNBlockProperties.BrownMushroomShape.TOP) {
            return TOP_CENTER_SHAPE;
        }
        if (shape == BNBlockProperties.BrownMushroomShape.MIDDLE || shape == BNBlockProperties.BrownMushroomShape.BOTTOM) {
            return MIDDLE_SHAPE;
        }
        return TOP_EDGE_SHAPE;
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        BNBlockProperties.BrownMushroomShape shape = (BNBlockProperties.BrownMushroomShape)((Object)state.getValue(SHAPE));
        int index = this.getRotationIndex(shape, ROT_SIDE);
        if (index < 0) {
            index = this.getRotationIndex(shape, ROT_CORNER);
            if (index < 0) {
                return state;
            }
            int offset = this.rotOffset(rotation);
            return (BlockState)state.setValue(SHAPE, (Comparable)((Object)ROT_CORNER[index + offset & 3]));
        }
        int offset = this.rotOffset(rotation);
        return (BlockState)state.setValue(SHAPE, (Comparable)((Object)ROT_SIDE[index + offset & 3]));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        BNBlockProperties.BrownMushroomShape shape = (BNBlockProperties.BrownMushroomShape)((Object)state.getValue(SHAPE));
        int index = this.getRotationIndex(shape, ROT_SIDE);
        if (index < 0) {
            index = this.getRotationIndex(shape, ROT_CORNER);
            if (index < 0) {
                return state;
            }
            if (mirror == Mirror.FRONT_BACK) {
                if (shape == BNBlockProperties.BrownMushroomShape.CORNER_E) {
                    shape = BNBlockProperties.BrownMushroomShape.CORNER_W;
                } else if (shape == BNBlockProperties.BrownMushroomShape.CORNER_W) {
                    shape = BNBlockProperties.BrownMushroomShape.CORNER_E;
                }
            } else if (mirror == Mirror.LEFT_RIGHT) {
                if (shape == BNBlockProperties.BrownMushroomShape.CORNER_N) {
                    shape = BNBlockProperties.BrownMushroomShape.CORNER_S;
                } else if (shape == BNBlockProperties.BrownMushroomShape.CORNER_S) {
                    shape = BNBlockProperties.BrownMushroomShape.CORNER_N;
                }
            }
            return (BlockState)state.setValue(SHAPE, (Comparable)((Object)shape));
        }
        if (mirror == Mirror.FRONT_BACK) {
            if (shape == BNBlockProperties.BrownMushroomShape.SIDE_E) {
                shape = BNBlockProperties.BrownMushroomShape.SIDE_W;
            } else if (shape == BNBlockProperties.BrownMushroomShape.SIDE_W) {
                shape = BNBlockProperties.BrownMushroomShape.SIDE_E;
            }
        } else if (mirror == Mirror.LEFT_RIGHT) {
            if (shape == BNBlockProperties.BrownMushroomShape.SIDE_N) {
                shape = BNBlockProperties.BrownMushroomShape.SIDE_S;
            } else if (shape == BNBlockProperties.BrownMushroomShape.SIDE_S) {
                shape = BNBlockProperties.BrownMushroomShape.SIDE_N;
            }
        }
        return (BlockState)state.setValue(SHAPE, (Comparable)((Object)shape));
    }

    private int getRotationIndex(BNBlockProperties.BrownMushroomShape shape, BNBlockProperties.BrownMushroomShape[] rotations) {
        for (int i = 0; i < 4; ++i) {
            if (shape != rotations[i]) continue;
            return i;
        }
        return -1;
    }

    private int rotOffset(Rotation rotation) {
        if (rotation == Rotation.NONE) {
            return 0;
        }
        if (rotation == Rotation.CLOCKWISE_90) {
            return 1;
        }
        if (rotation == Rotation.CLOCKWISE_180) {
            return 2;
        }
        return 3;
    }

    public BlockState updateShape(BlockState state, Direction facing, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        switch ((BNBlockProperties.BrownMushroomShape)((Object)state.getValue(SHAPE))) {
            case BOTTOM: {
                return state;
            }
            default: {
                return this.getStateIfSame(state, world, pos.below());
            }
            case SIDE_E: 
            case CORNER_E: {
                return this.getStateIfSame(state, world, pos.west());
            }
            case SIDE_N: 
            case CORNER_N: {
                return this.getStateIfSame(state, world, pos.south());
            }
            case SIDE_S: 
            case CORNER_S: {
                return this.getStateIfSame(state, world, pos.north());
            }
            case SIDE_W: 
            case CORNER_W: 
        }
        return this.getStateIfSame(state, world, pos.east());
    }

    private BlockState getStateIfSame(BlockState state, LevelAccessor world, BlockPos pos) {
        return world.getBlockState(pos).getBlock() == this ? state : Blocks.AIR.defaultBlockState();
    }
}

