/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.blocks;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.betterx.bclib.behaviours.interfaces.BehaviourStone;
import org.betterx.betternether.blocks.BlockBaseNotFull;
import org.betterx.wover.tag.api.predefined.CommonBlockTags;

public class BlockGeyser
extends BlockBaseNotFull
implements BehaviourStone {
    private static final VoxelShape SHAPE = BlockGeyser.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)4.0, (double)15.0);

    public BlockGeyser() {
        super(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.NETHERRACK).lightLevel(state -> 10).noOcclusion());
    }

    public VoxelShape getShape(BlockState state, BlockGetter view, BlockPos pos, CollisionContext ePos) {
        return SHAPE;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void animateTick(BlockState state, Level world, BlockPos pos, RandomSource random) {
        for (int i = 0; i < 5; ++i) {
            world.addParticle((ParticleOptions)ParticleTypes.FLAME, (double)pos.getX() + 0.4 + random.nextDouble() * 0.1, (double)pos.getY() + 0.125, (double)pos.getZ() + 0.4 + random.nextDouble() * 0.1, random.nextDouble() * 0.02 - 0.01, 0.05 + random.nextDouble() * 0.05, random.nextDouble() * 0.02 - 0.01);
            world.addParticle((ParticleOptions)ParticleTypes.LARGE_SMOKE, (double)pos.getX() + 0.4 + random.nextDouble() * 0.1, (double)pos.getY() + 0.125, (double)pos.getZ() + 0.4 + random.nextDouble() * 0.1, random.nextDouble() * 0.02 - 0.01, 0.05 + random.nextDouble() * 0.05, random.nextDouble() * 0.02 - 0.01);
            world.addParticle((ParticleOptions)ParticleTypes.LAVA, (double)pos.getX() + 0.4 + random.nextDouble() * 0.1, (double)pos.getY() + 0.125 + random.nextDouble() * 0.1, (double)pos.getZ() + 0.4 + random.nextDouble() * 0.1, random.nextDouble() * 0.02 - 0.01, 0.05 + random.nextDouble() * 0.05, random.nextDouble() * 0.02 - 0.01);
        }
        if (random.nextDouble() < 0.1) {
            world.playLocalSound((double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5, SoundEvents.FIRE_AMBIENT, SoundSource.BLOCKS, 1.0f, 1.0f, false);
        }
        if (random.nextDouble() < 0.1) {
            world.playLocalSound((double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5, SoundEvents.FURNACE_FIRE_CRACKLE, SoundSource.BLOCKS, 1.0f, 1.0f, false);
        }
        if (random.nextDouble() < 0.1) {
            world.playLocalSound((double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5, SoundEvents.LAVA_POP, SoundSource.BLOCKS, 1.0f, 1.0f, false);
        }
    }

    public void stepOn(Level world, BlockPos pos, BlockState state, Entity entity) {
        if (!entity.fireImmune() && entity instanceof LivingEntity) {
            entity.hurt(world.damageSources().inFire(), 3.0f);
            entity.igniteForSeconds(1.0f);
        }
        super.stepOn(world, pos, state, entity);
    }

    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        return world.getBlockState(pos.below()).is(CommonBlockTags.TERRAIN);
    }

    public BlockState updateShape(BlockState state, Direction facing, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (!this.canSurvive(state, (LevelReader)world, pos)) {
            return Blocks.AIR.defaultBlockState();
        }
        return state;
    }
}

