/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.blocks;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.fml.ModList;
import org.betterx.bclib.interfaces.tools.AddMineableAxe;
import org.betterx.betternether.MHelper;
import org.betterx.betternether.blocks.BNBlockProperties;
import org.betterx.betternether.blocks.BNRenderLayer;
import org.betterx.betternether.blocks.BlockBaseNotFull;
import org.betterx.betternether.blocks.materials.Materials;
import org.betterx.betternether.registry.NetherBlocks;
import org.betterx.betternether.registry.NetherItems;
import org.betterx.wover.block.api.BlockProperties;

public class BlockJellyfishMushroom
extends BlockBaseNotFull
implements AddMineableAxe {
    private static final VoxelShape TOP_SHAPE = BlockJellyfishMushroom.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);
    private static final VoxelShape MIDDLE_SHAPE = BlockJellyfishMushroom.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);
    public static final EnumProperty<BlockProperties.TripleShape> SHAPE = BlockProperties.TRIPLE_SHAPE;
    public static final EnumProperty<BNBlockProperties.JellyShape> VISUAL = BNBlockProperties.JELLY_MUSHROOM_VISUAL;

    public BlockJellyfishMushroom() {
        super(Materials.makeNetherWood(MapColor.COLOR_CYAN).lightLevel(s -> 13).destroyTime(0.1f).sound(SoundType.FUNGUS).strength(1.0f).noOcclusion());
        boolean sodium = ModList.get().isLoaded("sodium");
        this.setRenderLayer(sodium ? BNRenderLayer.CUTOUT : BNRenderLayer.TRANSLUCENT);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> stateManager) {
        stateManager.add(new Property[]{SHAPE, VISUAL});
    }

    public VoxelShape getShape(BlockState state, BlockGetter view, BlockPos pos, CollisionContext ePos) {
        return state.getValue(SHAPE) == BlockProperties.TripleShape.TOP ? TOP_SHAPE : MIDDLE_SHAPE;
    }

    @OnlyIn(value=Dist.CLIENT)
    public ItemStack getCloneItemStack(LevelReader world, BlockPos pos, BlockState state) {
        return new ItemStack((ItemLike)NetherBlocks.JELLYFISH_MUSHROOM_SAPLING);
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getShadeBrightness(BlockState state, BlockGetter view, BlockPos pos) {
        return 1.0f;
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter view, BlockPos pos) {
        return true;
    }

    public BlockState updateShape(BlockState state, Direction facing, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        switch ((BlockProperties.TripleShape)state.getValue(SHAPE)) {
            case BOTTOM: {
                return world.getBlockState(pos.below()).isFaceSturdy((BlockGetter)world, pos.below(), Direction.UP) ? state : Blocks.AIR.defaultBlockState();
            }
            case MIDDLE: {
                return world.getBlockState(pos.above()).getBlock() == this && world.getBlockState(pos.below()).isFaceSturdy((BlockGetter)world, pos.below(), Direction.UP) ? state : Blocks.AIR.defaultBlockState();
            }
        }
        return world.getBlockState(pos.below()).getBlock() == this ? state : Blocks.AIR.defaultBlockState();
    }

    public void fallOn(Level world, BlockState state, BlockPos pos, Entity entity, float fallDistance) {
        if (world.getBlockState(pos).getValue(SHAPE) != BlockProperties.TripleShape.TOP) {
            return;
        }
        if (entity.isSuppressingBounce()) {
            super.fallOn(world, state, pos, entity, fallDistance);
        } else {
            entity.causeFallDamage(fallDistance, 0.0f, world.damageSources().fall());
        }
    }

    public void updateEntityAfterFallOn(BlockGetter world, Entity entity) {
        if (entity.isSuppressingBounce()) {
            super.updateEntityAfterFallOn(world, entity);
        } else {
            this.bounce(entity);
        }
    }

    private void bounce(Entity entity) {
        Vec3 vec3d = entity.getDeltaMovement();
        if (vec3d.y < 0.0) {
            double d = entity instanceof LivingEntity ? 1.0 : 0.8;
            entity.setDeltaMovement(vec3d.x, -vec3d.y * d, vec3d.z);
        }
    }

    public void stepOn(Level world, BlockPos pos, BlockState state, Entity entity) {
        if (world.getBlockState(pos).getValue(SHAPE) != BlockProperties.TripleShape.TOP) {
            super.stepOn(world, pos, state, entity);
            return;
        }
        double d = Math.abs(entity.getDeltaMovement().y);
        if (d < 0.1 && !entity.isSteppingCarefully()) {
            double e = 0.4 + d * 0.2;
            entity.setDeltaMovement(entity.getDeltaMovement().multiply(e, 1.0, e));
        }
        super.stepOn(world, pos, state, entity);
    }

    @Override
    public List<ItemStack> getDrops(BlockState state, LootParams.Builder builder) {
        if (state.getValue(SHAPE) == BlockProperties.TripleShape.TOP) {
            return Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((ItemLike)NetherBlocks.JELLYFISH_MUSHROOM_SAPLING, MHelper.randRange(1, 2, MHelper.RANDOM)), new ItemStack((ItemLike)NetherItems.GLOWSTONE_PILE, MHelper.randRange(0, 2, MHelper.RANDOM)), new ItemStack((ItemLike)Items.SLIME_BALL, MHelper.randRange(0, 1, MHelper.RANDOM))});
        }
        if (state.getValue(SHAPE) == BlockProperties.TripleShape.BOTTOM) {
            return Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((ItemLike)NetherBlocks.JELLYFISH_MUSHROOM_SAPLING, MHelper.randRange(1, 2, MHelper.RANDOM))});
        }
        return Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((ItemLike)NetherBlocks.MAT_NETHER_MUSHROOM.getStem())});
    }
}

