/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.blocks;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.betterx.bclib.behaviours.interfaces.BehaviourSapling;
import org.betterx.betternether.BlocksHelper;
import org.betterx.betternether.blocks.BNRenderLayer;
import org.betterx.betternether.blocks.BlockBaseNotFull;
import org.betterx.betternether.blocks.materials.Materials;
import org.betterx.betternether.interfaces.SurvivesOnNylium;
import org.betterx.betternether.registry.features.configured.NetherVegetation;
import org.betterx.wover.state.api.WorldState;

public class BlockJellyfishMushroomSapling
extends BlockBaseNotFull
implements BonemealableBlock,
SurvivesOnNylium,
BehaviourSapling {
    private static final VoxelShape SHAPE = BlockJellyfishMushroomSapling.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)6.0, (double)12.0);

    public BlockJellyfishMushroomSapling() {
        super(Materials.NETHER_SAPLING.mapColor(MapColor.COLOR_CYAN).lightLevel(bs -> 9));
        this.setRenderLayer(BNRenderLayer.CUTOUT);
    }

    public VoxelShape getShape(BlockState state, BlockGetter view, BlockPos pos, CollisionContext ePos) {
        return SHAPE;
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        return this.canSurviveOnTop(level, pos);
    }

    public BlockState updateShape(BlockState state, Direction facing, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (!this.canSurvive(state, (LevelReader)world, pos)) {
            return Blocks.AIR.defaultBlockState();
        }
        return state;
    }

    public boolean isValidBonemealTarget(LevelReader world, BlockPos pos, BlockState state) {
        return true;
    }

    public boolean isBonemealSuccess(Level world, RandomSource random, BlockPos pos, BlockState state) {
        return BlocksHelper.isFertile(world.getBlockState(pos.below())) ? random.nextInt(8) == 0 : random.nextInt(16) == 0;
    }

    public void performBonemeal(ServerLevel world, RandomSource random, BlockPos pos, BlockState state) {
        NetherVegetation.JELLYFISH_MUSHROOM.placeInWorld(WorldState.registryAccess(), (WorldGenLevel)world, pos, random);
    }

    public void randomTick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        super.randomTick(state, world, pos, random);
        if (this.isBonemealSuccess((Level)world, random, pos, state)) {
            this.performBonemeal(world, random, pos, state);
        }
    }
}

