/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.blocks;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.betterx.bclib.behaviours.BehaviourBuilders;
import org.betterx.bclib.interfaces.tools.AddMineableAxe;
import org.betterx.betternether.BlocksHelper;
import org.betterx.betternether.MHelper;
import org.betterx.betternether.blocks.BNBlockProperties;
import org.betterx.betternether.blocks.BlockBaseNotFull;
import org.betterx.betternether.registry.NetherBlocks;
import org.betterx.betternether.registry.NetherItems;

public class BlockLucisMushroom
extends BlockBaseNotFull
implements AddMineableAxe {
    private static final VoxelShape V_SHAPE = BlockLucisMushroom.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)9.0, (double)16.0);
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    public static final EnumProperty<BNBlockProperties.EnumLucisShape> SHAPE = BNBlockProperties.LUCIS_SHAPE;

    public BlockLucisMushroom() {
        super(BehaviourBuilders.createWalkablePlant((MapColor)MapColor.COLOR_YELLOW).lightLevel(bs -> 15).requiresCorrectToolForDrops().sound(SoundType.WOOD).strength(1.0f));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue(SHAPE, (Comparable)((Object)BNBlockProperties.EnumLucisShape.CORNER)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> stateManager) {
        stateManager.add(new Property[]{FACING, SHAPE});
    }

    public VoxelShape getShape(BlockState state, BlockGetter view, BlockPos pos, CollisionContext ePos) {
        return V_SHAPE;
    }

    @Override
    public List<ItemStack> getDrops(BlockState state, LootParams.Builder builder) {
        return Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((ItemLike)NetherBlocks.LUCIS_SPORE), new ItemStack((ItemLike)NetherItems.GLOWSTONE_PILE, MHelper.randRange(2, 4, MHelper.RANDOM))});
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return BlocksHelper.rotateHorizontal(state, rotation, (Property<Direction>)FACING);
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        if (mirror == Mirror.FRONT_BACK) {
            if (state.getValue(SHAPE) == BNBlockProperties.EnumLucisShape.SIDE) {
                state = (BlockState)state.setValue((Property)FACING, (Comparable)((Direction)state.getValue((Property)FACING)).getCounterClockWise());
            }
            if (state.getValue((Property)FACING) == Direction.NORTH) {
                return (BlockState)state.setValue((Property)FACING, (Comparable)Direction.WEST);
            }
            if (state.getValue((Property)FACING) == Direction.WEST) {
                return (BlockState)state.setValue((Property)FACING, (Comparable)Direction.NORTH);
            }
            if (state.getValue((Property)FACING) == Direction.SOUTH) {
                return (BlockState)state.setValue((Property)FACING, (Comparable)Direction.EAST);
            }
            if (state.getValue((Property)FACING) == Direction.EAST) {
                return (BlockState)state.setValue((Property)FACING, (Comparable)Direction.SOUTH);
            }
        } else if (mirror == Mirror.LEFT_RIGHT) {
            if (state.getValue(SHAPE) == BNBlockProperties.EnumLucisShape.SIDE) {
                state = (BlockState)state.setValue((Property)FACING, (Comparable)((Direction)state.getValue((Property)FACING)).getCounterClockWise());
            }
            if (state.getValue((Property)FACING) == Direction.NORTH) {
                return (BlockState)state.setValue((Property)FACING, (Comparable)Direction.EAST);
            }
            if (state.getValue((Property)FACING) == Direction.EAST) {
                return (BlockState)state.setValue((Property)FACING, (Comparable)Direction.NORTH);
            }
            if (state.getValue((Property)FACING) == Direction.SOUTH) {
                return (BlockState)state.setValue((Property)FACING, (Comparable)Direction.WEST);
            }
            if (state.getValue((Property)FACING) == Direction.WEST) {
                return (BlockState)state.setValue((Property)FACING, (Comparable)Direction.SOUTH);
            }
        }
        return state;
    }

    @OnlyIn(value=Dist.CLIENT)
    public ItemStack getCloneItemStack(LevelReader world, BlockPos pos, BlockState state) {
        return new ItemStack((ItemLike)NetherBlocks.LUCIS_SPORE);
    }
}

