/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.blocks;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.betterx.bclib.api.v3.bonemeal.BonemealAPI;
import org.betterx.bclib.behaviours.interfaces.BehaviourSeed;
import org.betterx.betternether.blocks.BNRenderLayer;
import org.betterx.betternether.blocks.BlockBaseNotFull;
import org.betterx.betternether.blocks.materials.Materials;
import org.betterx.betternether.world.features.DeferedSeedBlock;
import org.betterx.wover.feature.api.FeatureUtils;

public class BlockLumabusSeed
extends BlockBaseNotFull
implements BonemealableBlock,
BehaviourSeed {
    private static final VoxelShape SHAPE = BlockLumabusSeed.box((double)4.0, (double)6.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    private final BonemealAPI.FeatureProvider feature;

    public BlockLumabusSeed(DeferedSeedBlock parent, BonemealAPI.FeatureProvider feature) {
        super(Materials.NETHER_SAPLING.mapColor(MapColor.COLOR_RED));
        this.setRenderLayer(BNRenderLayer.CUTOUT);
        this.feature = feature;
        parent.setSeed(this);
    }

    public VoxelShape getShape(BlockState state, BlockGetter view, BlockPos pos, CollisionContext ePos) {
        return SHAPE;
    }

    public boolean isValidBonemealTarget(LevelReader world, BlockPos pos, BlockState state) {
        return true;
    }

    public boolean isBonemealSuccess(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return random.nextInt(4) == 0 && level.getBlockState(pos.below()).getBlock() == Blocks.AIR;
    }

    public void performBonemeal(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        FeatureUtils.placeInWorld((ConfiguredFeature)((ConfiguredFeature)this.feature.getFeature().value()), (WorldGenLevel)level, (BlockPos)pos, (RandomSource)random, (boolean)false);
    }

    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        BlockState upState = world.getBlockState(pos.above());
        return upState.isFaceSturdy((BlockGetter)world, pos, Direction.DOWN);
    }

    public BlockState updateShape(BlockState state, Direction facing, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (!this.canSurvive(state, (LevelReader)world, pos)) {
            return Blocks.AIR.defaultBlockState();
        }
        return state;
    }

    public void randomTick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        super.randomTick(state, world, pos, random);
        if (this.isBonemealSuccess((Level)world, random, pos, state)) {
            this.performBonemeal(world, random, pos, state);
        }
    }
}

