/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.blocks;

import java.util.function.ToIntFunction;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.predicates.BonusLevelTableCondition;
import net.minecraft.world.level.storage.loot.predicates.ExplosionCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.betterx.bclib.behaviours.BehaviourBuilders;
import org.betterx.bclib.blocks.BaseVineBlock;
import org.betterx.betternether.registry.NetherItems;
import org.betterx.betternether.world.features.DeferedSeedBlock;
import org.betterx.wover.block.api.BlockProperties;
import org.betterx.wover.loot.api.BlockLootProvider;
import org.betterx.wover.loot.api.LootLookupProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockLumabusVine
extends BaseVineBlock
implements DeferedSeedBlock,
BlockLootProvider {
    private static final VoxelShape MIDDLE_SHAPE = BlockLumabusVine.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    static final VoxelShape BOTTOM_SHAPE = BlockLumabusVine.box((double)2.0, (double)4.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    private Block seed;

    public BlockLumabusVine(MapColor color) {
        super(BehaviourBuilders.createStaticVine((MapColor)color).lightLevel(BlockLumabusVine.getLuminance()), 9, 1);
    }

    @Override
    public void setSeed(Block seed) {
        this.seed = seed;
    }

    private static ToIntFunction<BlockState> getLuminance() {
        return blockState -> blockState.getOptionalValue((Property)SHAPE).orElse(BlockProperties.TripleShape.TOP) == BlockProperties.TripleShape.BOTTOM ? 15 : 0;
    }

    public VoxelShape getShape(BlockState state, BlockGetter view, BlockPos pos, CollisionContext ePos) {
        return state.getValue((Property)SHAPE) == BlockProperties.TripleShape.BOTTOM ? BOTTOM_SHAPE : MIDDLE_SHAPE;
    }

    @OnlyIn(value=Dist.CLIENT)
    @NotNull
    public ItemStack getCloneItemStack(@NotNull LevelReader level, @NotNull BlockPos pos, @NotNull BlockState state) {
        return new ItemStack((ItemLike)this.seed);
    }

    @Nullable
    public LootTable.Builder registerBlockLoot(@NotNull ResourceLocation location, @NotNull LootLookupProvider provider, @NotNull ResourceKey<LootTable> tableKey) {
        LootItemBlockStatePropertyCondition.Builder fruityState = LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)this).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)SHAPE, (Comparable)BlockProperties.TripleShape.BOTTOM));
        return LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)this.seed).when((LootItemCondition.Builder)fruityState.and(provider.shearsOrSilkTouchCondition()))).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)3.0f))).otherwise(((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)this.seed).when(ExplosionCondition.survivesExplosion())).when(BonusLevelTableCondition.bonusLevelFlatChance((Holder)provider.fortune(), (float[])LootLookupProvider.VANILLA_LEAVES_SAPLING_CHANCES))))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)NetherItems.GLOWSTONE_PILE).when((LootItemCondition.Builder)fruityState.and(provider.shearsOrHoeSilkTouchCondition()))).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)3.0f)))));
    }
}

