/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.blocks;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.betterx.bclib.behaviours.interfaces.BehaviourWood;
import org.betterx.betternether.blocks.BNRenderLayer;
import org.betterx.betternether.blocks.BlockBaseNotFull;
import org.betterx.betternether.blocks.materials.Materials;
import org.betterx.betternether.registry.NetherBlocks;

public class BlockMushroomFir
extends BlockBaseNotFull
implements BehaviourWood {
    public static final EnumProperty<MushroomFirShape> SHAPE = EnumProperty.create((String)"shape", MushroomFirShape.class);
    private static final VoxelShape BOTTOM_SHAPE = BlockMushroomFir.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    private static final VoxelShape MIDDLE_SHAPE = BlockMushroomFir.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);
    private static final VoxelShape TOP_SHAPE = BlockMushroomFir.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
    private static final VoxelShape SIDE_BIG_SHAPE = BlockMushroomFir.box((double)0.01, (double)0.01, (double)0.01, (double)15.99, (double)13.0, (double)15.99);
    private static final VoxelShape SIDE_SMALL_N_SHAPE = BlockMushroomFir.box((double)4.0, (double)1.0, (double)0.0, (double)12.0, (double)8.0, (double)8.0);
    private static final VoxelShape SIDE_SMALL_S_SHAPE = BlockMushroomFir.box((double)4.0, (double)1.0, (double)8.0, (double)12.0, (double)8.0, (double)16.0);
    private static final VoxelShape SIDE_SMALL_E_SHAPE = BlockMushroomFir.box((double)8.0, (double)1.0, (double)4.0, (double)16.0, (double)8.0, (double)12.0);
    private static final VoxelShape SIDE_SMALL_W_SHAPE = BlockMushroomFir.box((double)0.0, (double)1.0, (double)4.0, (double)8.0, (double)8.0, (double)12.0);
    private static final VoxelShape END_SHAPE = BlockMushroomFir.box((double)0.01, (double)0.0, (double)0.01, (double)15.99, (double)15.99, (double)15.99);

    public BlockMushroomFir() {
        super(Materials.makeNetherWood(MapColor.COLOR_CYAN).noOcclusion());
        this.setDropItself(false);
        this.setRenderLayer(BNRenderLayer.CUTOUT);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> stateManager) {
        stateManager.add(new Property[]{SHAPE});
    }

    public VoxelShape getShape(BlockState state, BlockGetter view, BlockPos pos, CollisionContext ePos) {
        switch (((MushroomFirShape)((Object)state.getValue(SHAPE))).ordinal()) {
            case 0: {
                return BOTTOM_SHAPE;
            }
            case 11: {
                return END_SHAPE;
            }
            default: {
                return MIDDLE_SHAPE;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                return SIDE_BIG_SHAPE;
            }
            case 9: {
                return SIDE_SMALL_E_SHAPE;
            }
            case 7: {
                return SIDE_SMALL_N_SHAPE;
            }
            case 8: {
                return SIDE_SMALL_S_SHAPE;
            }
            case 10: {
                return SIDE_SMALL_W_SHAPE;
            }
            case 2: 
        }
        return TOP_SHAPE;
    }

    @OnlyIn(value=Dist.CLIENT)
    public ItemStack getCloneItemStack(LevelReader world, BlockPos pos, BlockState state) {
        MushroomFirShape shape = (MushroomFirShape)((Object)state.getValue(SHAPE));
        return shape == MushroomFirShape.BOTTOM || shape == MushroomFirShape.MIDDLE ? new ItemStack((ItemLike)NetherBlocks.MAT_MUSHROOM_FIR.getStem()) : new ItemStack((ItemLike)NetherBlocks.MAT_MUSHROOM_FIR.getSapling());
    }

    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        Comparable _shape = (Comparable)state.getValues().get(SHAPE);
        if (_shape == null) {
            return false;
        }
        MushroomFirShape shape = (MushroomFirShape)((Object)SHAPE.getValueClass().cast(_shape));
        if (shape == MushroomFirShape.SIDE_BIG_N || shape == MushroomFirShape.SIDE_SMALL_N) {
            return world.getBlockState(pos.north()).getBlock() == this;
        }
        if (shape == MushroomFirShape.SIDE_BIG_S || shape == MushroomFirShape.SIDE_SMALL_S) {
            return world.getBlockState(pos.south()).getBlock() == this;
        }
        if (shape == MushroomFirShape.SIDE_BIG_E || shape == MushroomFirShape.SIDE_SMALL_E) {
            return world.getBlockState(pos.east()).getBlock() == this;
        }
        if (shape == MushroomFirShape.SIDE_BIG_W || shape == MushroomFirShape.SIDE_SMALL_W) {
            return world.getBlockState(pos.west()).getBlock() == this;
        }
        BlockState down = world.getBlockState(pos.below());
        return down.getBlock() == this || down.isFaceSturdy((BlockGetter)world, pos.below(), Direction.UP);
    }

    public BlockState updateShape(BlockState state, Direction facing, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        return this.canSurvive(state, (LevelReader)world, pos) ? state : Blocks.AIR.defaultBlockState();
    }

    public static enum MushroomFirShape implements StringRepresentable
    {
        BOTTOM("bottom"),
        MIDDLE("middle"),
        TOP("top"),
        SIDE_BIG_N("side_big_n"),
        SIDE_BIG_S("side_big_s"),
        SIDE_BIG_E("side_big_e"),
        SIDE_BIG_W("side_big_w"),
        SIDE_SMALL_N("side_small_n"),
        SIDE_SMALL_S("side_small_s"),
        SIDE_SMALL_E("side_small_e"),
        SIDE_SMALL_W("side_small_w"),
        END("end");

        final String name;

        private MushroomFirShape(String name) {
            this.name = name;
        }

        public String getSerializedName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }
}

