/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.blocks;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.data.models.blockstates.Variant;
import net.minecraft.data.models.blockstates.VariantProperties;
import net.minecraft.data.models.model.TextureSlot;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.betterx.betternether.BetterNether;
import org.betterx.betternether.blocks.BaseBlockNetherGrass;
import org.betterx.betternether.client.block.BNModels;
import org.betterx.betternether.interfaces.SurvivesOnNetherrackNyliumAndSculk;
import org.betterx.wover.block.api.model.BlockModelProvider;
import org.betterx.wover.block.api.model.WoverBlockModelGenerators;

public abstract class BlockNetherGrass
extends BaseBlockNetherGrass
implements SurvivesOnNetherrackNyliumAndSculk {
    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        return this.canSurviveOnTop(level, pos);
    }

    public boolean isTerrain(BlockState state) {
        return SurvivesOnNetherrackNyliumAndSculk.super.isTerrain(state);
    }

    public static class NetherGrass
    extends BlockNetherGrass
    implements BlockModelProvider {
        @OnlyIn(value=Dist.CLIENT)
        public void provideBlockModels(WoverBlockModelGenerators generators) {
            ResourceLocation T1 = BetterNether.C.mk("block/ngrass_1");
            ResourceLocation T2 = BetterNether.C.mk("block/ngrass_2");
            ResourceLocation T3 = BetterNether.C.mk("block/ngrass_3");
            BNModels.createComplex(generators, (Block)this, List.of(BNModels.ModelSource.of(BNModels.GRASS_FAN_MODEL_LOCATION, "_1", List.of((id, all) -> Variant.variant().with(VariantProperties.MODEL, (Object)id)), BNModels.TextureSource.of(TextureSlot.TEXTURE, T1)), BNModels.ModelSource.of(WoverBlockModelGenerators.CROSS, "_2", List.of((id, all) -> Variant.variant().with(VariantProperties.MODEL, (Object)id)), BNModels.TextureSource.of(TextureSlot.CROSS, T2)), BNModels.ModelSource.of(BNModels.GRASS_FAN_MODEL_LOCATION, "_3", List.of((id, all) -> Variant.variant().with(VariantProperties.MODEL, (Object)id)), BNModels.TextureSource.of(TextureSlot.TEXTURE, T3))));
        }
    }

    public static class SepiaBoneGrass
    extends BaseBlockNetherGrass.OnEverything
    implements BlockModelProvider {
        @OnlyIn(value=Dist.CLIENT)
        public void provideBlockModels(WoverBlockModelGenerators generators) {
            BNModels.provideGrassBlockModels(generators, (Block)this, "sepia_bone_grass", 3);
        }
    }

    public static class BoneGrass
    extends BaseBlockNetherGrass.OnEverything
    implements BlockModelProvider {
        @OnlyIn(value=Dist.CLIENT)
        public void provideBlockModels(WoverBlockModelGenerators generators) {
            BNModels.provideGrassBlockModels(generators, (Block)this, "bone_grass", 3);
        }
    }

    public static class SwampGrass
    extends BlockNetherGrass
    implements BlockModelProvider {
        @OnlyIn(value=Dist.CLIENT)
        public void provideBlockModels(WoverBlockModelGenerators generators) {
            BNModels.provideGrassBlockModels(generators, (Block)this, "swamp_grass", 3);
        }
    }

    public static class JunglePlant
    extends BlockNetherGrass
    implements BlockModelProvider {
        @OnlyIn(value=Dist.CLIENT)
        public void provideBlockModels(WoverBlockModelGenerators generators) {
            ResourceLocation JP1 = BetterNether.C.mk("block/jungle_plant_1");
            ResourceLocation JP2 = BetterNether.C.mk("block/jungle_plant_2");
            ResourceLocation JP3 = BetterNether.C.mk("block/jungle_plant_3");
            BNModels.createComplex(generators, (Block)this, List.of(BNModels.ModelSource.of(WoverBlockModelGenerators.CROSS, "_1_a", List.of((id, all) -> Variant.variant().with(VariantProperties.MODEL, (Object)id).with(VariantProperties.WEIGHT, (Object)10)), BNModels.TextureSource.of(TextureSlot.CROSS, JP1)), BNModels.ModelSource.of(BNModels.CROP_BLOCK_MODEL_LOCATION, "_1_b", List.of((id, all) -> Variant.variant().with(VariantProperties.MODEL, (Object)id).with(VariantProperties.WEIGHT, (Object)10)), BNModels.TextureSource.of(TextureSlot.TEXTURE, JP1)), BNModels.ModelSource.of(BNModels.JUNGLE_PLANT_MODEL_LOCATION, "_2", List.of((id, all) -> Variant.variant().with(VariantProperties.MODEL, (Object)id), (id, all) -> Variant.variant().with(VariantProperties.MODEL, (Object)id).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R90), (id, all) -> Variant.variant().with(VariantProperties.MODEL, (Object)id).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R180), (id, all) -> Variant.variant().with(VariantProperties.MODEL, (Object)id).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R270)), BNModels.TextureSource.of(TextureSlot.PARTICLE, JP2), BNModels.TextureSource.of(TextureSlot.TEXTURE, JP3)), BNModels.ModelSource.of(WoverBlockModelGenerators.CROSS, "_3", List.of((id, all) -> Variant.variant().with(VariantProperties.MODEL, (Object)id).with(VariantProperties.WEIGHT, (Object)2)), BNModels.TextureSource.of(TextureSlot.CROSS, JP3))));
        }
    }
}

