/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.blocks;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.betterx.bclib.behaviours.interfaces.BehaviourPlant;
import org.betterx.betternether.BlocksHelper;
import org.betterx.betternether.blocks.BNRenderLayer;
import org.betterx.betternether.blocks.BlockBaseNotFull;
import org.betterx.betternether.blocks.materials.Materials;

public class BlockPlantWall
extends BlockBaseNotFull
implements BehaviourPlant {
    private static final EnumMap<Direction, VoxelShape> BOUNDING_SHAPES = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, (Object)BlockPlantWall.box((double)2.0, (double)2.0, (double)10.0, (double)14.0, (double)14.0, (double)16.0), (Object)Direction.SOUTH, (Object)BlockPlantWall.box((double)2.0, (double)2.0, (double)0.0, (double)14.0, (double)14.0, (double)6.0), (Object)Direction.WEST, (Object)BlockPlantWall.box((double)10.0, (double)2.0, (double)2.0, (double)16.0, (double)14.0, (double)14.0), (Object)Direction.EAST, (Object)BlockPlantWall.box((double)0.0, (double)2.0, (double)2.0, (double)6.0, (double)14.0, (double)14.0)));
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;

    public BlockPlantWall(MapColor color) {
        super(Materials.makeNetherGrass(color).offsetType(BlockBehaviour.OffsetType.NONE));
        this.setRenderLayer(BNRenderLayer.CUTOUT);
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getShadeBrightness(BlockState state, BlockGetter view, BlockPos pos) {
        return 1.0f;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> stateManager) {
        stateManager.add(new Property[]{FACING});
    }

    public VoxelShape getShape(BlockState state, BlockGetter view, BlockPos pos, CollisionContext ePos) {
        return BOUNDING_SHAPES.get(state.getValue((Property)FACING));
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        Direction direction = (Direction)state.getValue((Property)FACING);
        BlockPos targetPos = pos.relative(direction.getOpposite());
        BlockState targetState = level.getBlockState(targetPos);
        return targetState.isFaceSturdy((BlockGetter)level, targetPos, direction);
    }

    public BlockState updateShape(BlockState state, Direction facing, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (this.canSurvive(state, (LevelReader)world, pos)) {
            return state;
        }
        return Blocks.AIR.defaultBlockState();
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return BlocksHelper.rotateHorizontal(state, rotation, (Property<Direction>)FACING);
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return BlocksHelper.mirrorHorizontal(state, mirror, (Property<Direction>)FACING);
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        BlockState blockState = this.defaultBlockState();
        Level worldView = ctx.getLevel();
        BlockPos blockPos = ctx.getClickedPos();
        Direction[] directions = ctx.getNearestLookingDirections();
        for (int i = 0; i < directions.length; ++i) {
            Direction direction2;
            Direction direction = directions[i];
            if (!direction.getAxis().isHorizontal() || !(blockState = (BlockState)blockState.setValue((Property)FACING, (Comparable)(direction2 = direction.getOpposite()))).canSurvive((LevelReader)worldView, blockPos)) continue;
            return blockState;
        }
        return null;
    }
}

