/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.blocks;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.betterx.bclib.interfaces.tools.AddMineableAxe;
import org.betterx.betternether.blocks.BNRenderLayer;
import org.betterx.betternether.blocks.BlockBaseNotFull;
import org.betterx.betternether.blocks.materials.Materials;
import org.betterx.betternether.registry.NetherBlocks;
import org.betterx.wover.block.api.BlockProperties;

public class BlockRedLargeMushroom
extends BlockBaseNotFull
implements AddMineableAxe {
    private static final VoxelShape TOP_SHAPE = BlockRedLargeMushroom.box((double)0.0, (double)0.1, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape MIDDLE_SHAPE = BlockRedLargeMushroom.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);
    public static final EnumProperty<BlockProperties.TripleShape> SHAPE = BlockProperties.TRIPLE_SHAPE;

    public BlockRedLargeMushroom() {
        super(Materials.makeNetherWood(MapColor.COLOR_RED).noOcclusion());
        this.setDropItself(false);
        this.setRenderLayer(BNRenderLayer.CUTOUT);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> stateManager) {
        stateManager.add(new Property[]{SHAPE});
    }

    public VoxelShape getShape(BlockState state, BlockGetter view, BlockPos pos, CollisionContext ePos) {
        return state.getValue(SHAPE) == BlockProperties.TripleShape.TOP ? TOP_SHAPE : MIDDLE_SHAPE;
    }

    @OnlyIn(value=Dist.CLIENT)
    public ItemStack getCloneItemStack(LevelReader world, BlockPos pos, BlockState state) {
        return state.getValue(SHAPE) == BlockProperties.TripleShape.TOP ? new ItemStack((ItemLike)Items.RED_MUSHROOM) : new ItemStack((ItemLike)NetherBlocks.MAT_NETHER_MUSHROOM.getStem());
    }

    public BlockState updateShape(BlockState state, Direction facing, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        switch ((BlockProperties.TripleShape)state.getValue(SHAPE)) {
            case BOTTOM: {
                return state;
            }
        }
        return world.getBlockState(pos.below()).getBlock() == this ? state : Blocks.AIR.defaultBlockState();
    }
}

